#include "mbed.h"
#define PRESSED 0

/** Nucleo-F091 Getting started
 * 
 * Basic fuctionality:
 * - Controls LED
 * - Reads userbutton
 * - Prints on serial terminal
 * - Reads character from serial terminal
 *
 *  To run the code on the mbed-simulator, change:
    - Change #define PRESSED 0 to 1 
    - Delete the Serial pc object
    - substitute pc.printf() by printf()
 */

Serial pc(SERIAL_TX, SERIAL_RX, 115200); 
//9600, 8 data bits, no parity,1 stop bit,no flow control
DigitalOut onboardLed(LED1);
DigitalIn userButton(BUTTON1, PullUp);

int main()
{
    // Initial sequence
    pc.printf("Hello World !\n\r");
    onboardLed=1;
    wait(1.0f); //https://en.cppreference.com/w/cpp/language/floating_literal
    onboardLed=!onboardLed;
    wait(1.0f);
    pc.printf("Press any key on the keyboard to start the program\n\r");
    pc.putc(pc.getc()); //echo keyboard input, blocking wait
    pc.printf(" was pressed\n\r");
    for (int32_t i=0;i<=10;i++){
        pc.printf("***\n\r"); //Generate some new lines
    }
        
    
    // Endless loop
    int32_t i=0;
    while(1) {
        onboardLed.write(1); //switch on LED
        wait_ms(300);
        onboardLed.write(0); //switch off
        wait_ms(700);
        pc.printf("This program runs since %d (0x%X) seconds.\n\r", i,i);
        if (userButton==PRESSED) {
            pc.printf("Userbutton pressed\n\r");
        }
        i++;    //increase loop counter        
    }
}
