/*
Código para controlar la comunicación entre la tarjeta y el pc a través de terminal
*/
#include "mbed.h"
//Se incluye la clase dibujar
#include "Dibujar.h"
//Se incluye la clase para el control de la memoria
#include "ControlMemoria.h"
//Se establecen los valores de los diferentes comandos principales
#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0

//Variable para establecer la comunicación USB
Serial command(USBTX, USBRX);

//Variable para poder llevar el conteo de las líneas de código correctas
int CantLineasCorr=0;

//Función encargada de ejecutar todo el código
void ejecutar()
{
    command.printf("Dibujando...");
    uint32_t *full = 0;

    if(CantLineasCorr>=1) {
        command.printf("Se inicia dibujo");
    } else {
        command.printf("No se han encontrado lineas de comando");
    }

    for(int i=0; i<=CantLineasCorr; i++) {

        //char Linea= mem_get(full);
        command.printf("Dibujando");

    }

    // ubicar acà el codigo
}

//Función encargada de empezar a guardar los comandos dentro de la pila
void guardar()
{
    command.printf("Se inicia el comado de guardar..");
    // ubicar acà el codigo

}

//Inicio de comunicación serial a 9600
void init_serial()
{
    command.baud(9600);
}

//Variables para determinar los valores iniciales de las posiciones X y Y
//Se establecen en -1 para saber cuando estas están cargadas con los valores reales
int intPosX=-1;
int intPosY=-1;
//Variable para identificar si la función que está siendo llamada es Vertex
bool VertexOn=false;

//Variable para almacenar una línea de comandos;
char LineaCodigo;
//Variable para determinar si la línea tiene el formato correcto
bool LineaCorrecta=false;


//Función para recibir los datos enviados desde el terminal
void RecibirDatos()
{
    //Se establece en un estado=1
    int Estado=1;

    //Mientras que el estado sea = 1 la tarjeta va a recibir los datos de la terminal
    while(Estado==1) {

        init_servo();
        init_serial();
        home();

        //Variable para almacenar la información en Hexadecimal desde terminal
        char read_cc;

        //El while=1 garantiza que todo el tiempo la tarjeta está recibiendo información
        while(1) {

            //se valida cuantas líneas correctas se han enviado
            if(CantLineasCorr<=10) {

                //Se almacena el dato en la variable read_cc
                read_cc=command.getc();

                //Si el parámetro enviado es 0xff se invoca la función ejecutar
                if(read_cc==CM_EJECUTAR) {
                    //Se invoca el comando ejecutar para empezar a dibujar
                    ejecutar();
                }

                //Si el parámetro enviado es 0xfe se invoca la función guardar
                if(read_cc==CM_GUARDAR) {
                    //Se hace el llamado a la función guardar
                    guardar();
                }

                //Si el parámetro enviado es 0xfd se invoca la función Vertex2D
                if(read_cc==CM_VERTEX2D || VertexOn) {

                    //Se establece la variable VertexOn=true para poder recibir los valores en X y Y
                    VertexOn=true;

                    /*

                        IMPORTANTE PARA LA EXPLICACIÓN AL PROFESOR:

                        La validación del número se hace para evitar que lleguen parámetros no deseados a la función vertex,
                        con un solo valor que llegue y no sea númerico puede generar fallos en la función Vertex

                        Casos de error:
                        Vertex2d(6,k);
                        Vertex2d(k,6);

                        Caso correcto:
                        Vertex2d(5,5);

                        La razón por la que X y Y están con un if y un elseif es porque si estuvieran en if separados,
                        se podría almacenar 2 valores en X y Y quedaría =-1

                    */


                    //Se valida que el valor que está siendo ingresado sea un número
                    if(read_cc>=0x30 && read_cc<=0x39) {

                        //se realiza la resta de -48 al valor enviado para poder obtener el valor decimal exacto
                        double Coord=(read_cc-48);

                        //Se valida si la posición en X ya fue asignada
                        if(intPosX==-1) {
                            //Se asigna el valor en la posición X
                            intPosX=Coord;
                            //Se valida si la posición en Y ya fue asignada
                        } else if(intPosY==-1) {
                            //Se asigna el valor en la posición Y
                            intPosY=Coord;
                            //Se establece vertex en false para poder dar continuidad a la siguiente línea de código
                            VertexOn=false;

                            LineaCorrecta=true;
                            LineaCodigo='FD ' +  intPosX + ',' + intPosY;

                        }
                    } else {
                        //Se establece que la línea enviada no es correcta y se ignora el envío a la pila
                        LineaCorrecta=true;
                        //Si el valor enviado no es numérico el paquete debe descartarse
                        VertexOn=false;
                    }

                }

                //Si el parámetro enviado es 0xfc se invoca la función DRAW
                if(read_cc==CM_DRAW) {
                    //Invocar la función Draw
                    //Se establece que la línea está correcta y se almacena el valor en la línea de código
                    LineaCorrecta=true;
                    LineaCodigo='DRAW';
                }

                //Si el parámetro enviado es 0xfb se invoca la función No draw
                if(read_cc==CM_NODRAW) {
                    //Invocar el función no draw
                    //Se establece que la línea está correcta y se almacena el valor en la línea de código
                    LineaCorrecta=true;
                    LineaCodigo='NO_DRAW';
                }

                //Si el parámetro enviado es 0xfa se invoca la función STOP
                if(read_cc==CM_STOP) {
                    //Invocar el función STOP
                    LineaCorrecta=true;
                    LineaCodigo='NO_DRAW';
                }

                //Si el parámetro enviado es 0xf0 se toma como fin de instrucción
                //CUANDO EXPLIQUEN ESTO AL PROFESOR DEFINAN EL F0 COMO AL EQUIVALENTE A UN ;
                if(read_cc==CM_END) {

                    if( LineaCorrecta) {

                        //Se aumenta el valor de las líneas correctas que se han enviado
                        CantLineasCorr+=1;
                        //Se envía la línea a la pila
                        mem_set(LineaCodigo);
                    }
                }
            } else {

                command.printf("Se ha alcanzado el máximo de líneas");

            }
        }
    }
}
