/*
Código para controlar la comunicación entre la tarjeta y el pc a través de terminal
*/
#include "mbed.h"
//Se incluye la clase dibujar
#include "draw.h"

#include "stepmotor.h"

//Se establecen los valores de los diferentes comandos principales
#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0

#define MEM_SIZE 10
#define MEM_TYPE uint32_t

//Variable para establecer la comunicación USB
Serial command(USBTX, USBRX);

uint8_t unitApuntador=0;
uint8_t unitFin=0;

MEM_TYPE bufferMemoria[MEM_SIZE];
MEM_TYPE bufferSalida[MEM_SIZE];
MEM_TYPE* data;

MEM_TYPE buffer[MEM_SIZE];
uint8_t mem_head = 0;
uint8_t mem_tail = 0;

bool full = 0;

bool mem_set(MEM_TYPE data);
int intValorMaximo=5000;
int intValorActual=0;

/*
    Se manejan 3 estados:
    1 Stand By (por default)
    2 Guardando Datos
    3 Ejecutando códigio/dibujando
*/
int intEstado=1;

//Objeto para la comunicación serial entre el PC y la tarjeta
Serial pc(USBTX,USBRX);


//Función encargada de ejecutar todo el código
void ejecutar()
{
    command.printf("se inicia el comando de ejecutar...\n");
    uint8_t valLec=0;
    uint8_t unintValX=0;
    uint8_t unintValY=0;


    for(int i=0; i<=mem_head; i++) {

        char chValorRecibido = buffer[i];
        //command.printf(""+chValorRecibido);

        if(chValorRecibido==CM_DRAW) {

            command.printf("Ejecutando comando Draw");
            draw();

        } else if(chValorRecibido==CM_NODRAW) {

            command.printf("Ejecutando comando No Draw");
            nodraw();

        } else if(chValorRecibido==CM_STOP) {

            command.printf("Ejecutando comando STOP");

        } else {

            command.printf("Piccolo dibujando, por favor espere");

            valLec=buffer[i]>>8;
    
            if(valLec<=0x32) {

                unintValY=valLec;
                valLec=buffer[i]>>8>>8;

                if(valLec<=0x32) {

                    unintValX=valLec;
                    valLec=buffer[i]>>8>>8;
                    vertex2d(unintValX,unintValY);
                    
                    //command.printf("%x\n",valLec);
                    //command.printf("%x\n",unintValY);
                }

            }
        }
    }
    
     intEstado=1;
    
}


//Función encargada de empezar a guardar los comandos dentro de la pila
void guardar()
{
    command.printf("___Se inicia el comando de guardar___\n");
   
    MEM_TYPE memValorEnviar;
    char chValor1, chValor2;

    //El while=1 garantiza que todo el tiempo la tarjeta está recibiendo información
    while(intValorActual<=intValorMaximo && intEstado==2) {

        chValor1=command.getc();

        switch(chValor1) {

            case CM_VERTEX2D:

                chValor2=command.getc();
                if(chValor2<=0x39) {
                    memValorEnviar=CM_VERTEX2D;
                    memValorEnviar=memValorEnviar<<8;
                    memValorEnviar=memValorEnviar|chValor2;
                    chValor2=command.getc();

                    if(chValor2<=0x39) {
                        memValorEnviar=memValorEnviar<<8;
                        memValorEnviar=memValorEnviar|chValor2;
                        chValor2=command.getc();

                        if(chValor2==CM_END) {
                            memValorEnviar=memValorEnviar<<8;
                            memValorEnviar=memValorEnviar|CM_END;
                            mem_set(memValorEnviar);
                                
command.printf("Recibio Vertex\n");

                        }
                    }
                }

                break;

            case CM_DRAW:

                chValor2=command.getc();
                if(chValor2==CM_END) {
                    memValorEnviar=chValor1;
                    mem_set(memValorEnviar);
                }
                command.printf("Recibio draw\n");

                break;

            case CM_NODRAW:

                chValor2=command.getc();
                if(chValor2==CM_END) {
                    memValorEnviar=chValor1;
                    command.printf("recibio nodraw\n");
                    mem_set(memValorEnviar);
                }

                break;

            case CM_STOP:

                if(chValor2==CM_END) {
                    chValor2=command.getc();                    
                    
                    command.printf("Fin de programa\n");
                chValor2=command.getc();
                    
                    
                        //Se establece el estado en 1 para que el piccolo quede en Stand By
                         intEstado=1;
                    
                }
                break;
        }

    }
   
   

}


//Inicio de comunicación serial a 9600
void init_serial()
{
    command.baud(9600);
}


//Función para recibir los datos enviados desde el terminal
void RecibirComandos()
{    
    char chValor1Rec;
    while(1)
    {
        chValor1Rec=command.getc();
        
        switch (chValor1Rec) {
            
            case  CM_EJECUTAR:
                intEstado=3;
                ejecutar(); 
                break;
                
            case  CM_GUARDAR: 
                intEstado=2;
                guardar(); 
                break;
                
            default: 
                intEstado=1;
                RecibirComandos();
                command.printf("error de comando");
                break ;
        }
    }
}


int main()
{
     init_servo();
    init_serial();
    home();
    
    RecibirComandos();
}


/* ***********************************************************************************
                CONTROL MEMORIA
/* ************************************************************************** */



void mem_free()  //Estaba como uint32_t no como void
{
    mem_head=0;
    full=0;
}

bool mem_set(MEM_TYPE data)  //Escribir
{
    if (full)
        return 1;
    buffer[mem_head] = data; //carga en dato en el buffer
    mem_head += 1;
    if (mem_head == MEM_SIZE)
        full =1;
    return 0;
}

bool  mem_get(MEM_TYPE* data)  //Leer
{
    if (mem_head == 0)
        return 1;
    if (mem_head == mem_tail)
        return 1;
    *data = buffer[mem_tail];
    mem_tail += 1;
    return 0;
}