#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

AnalogIn AI(PTC2);
AnalogOut AO(PTE30);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // Rs, E, D4-D7

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DebouncedIn button1(PTC12);
DebouncedIn button2(PTC13);
DebouncedIn button3(PTA1);
DebouncedIn button4(PTC16);

Timer t;
int flag;


/* Definiendo variables Globales */

int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C;    // Quita cursor bajo
int i;         // índice de la variable
int j;
int kp, ki, kd, sp, cycle;
int ap, ai, ad, err, PV, pid, err_v;
/* Programa fundamental*/


int main()
{
    /* Imprimir en Pantalla Los labels y valores=? de
     * los parametros del PID
     */

    lcd.cls();      //Borra la Pantalla
    lcd.printf("Sp%d",sp);
    lcd.locate(8,0);    //sistema coordenado para posicionar en pantalla
    lcd.printf("Kp%d",kp);
    lcd.locate(0,1);
    lcd.printf("Ki%d",ki);
    lcd.locate(8,1);
    lcd.printf("Kd%d",kd);
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    /*  No me cuadra muy bien la
     *  lectura de los valores (consultar en las otras tareas)
     */
    lcd.locate(0,0);
    lcd.printf("Sp%d",sp);

    /* Ciclo while para alterar los valores de los parametros*/
    while (1)
    {
        if (button3.falling()) //Boton con flanco de caida
        {
            ++j;
        }
        if (j==0)  //Este if realiza dos revisiones y actua solo en este valor (SP)
        {
            lcd.locate(2,0);
            lcd.printf("%d",sp); //sigo con la inquietud del write lectura
            if (button1.falling())
            {
                ++sp;
            }
            if (button2.falling())
            {
                --sp;
            }
        }
        if (j==1)  //Verificar si estos if son mas efectivos quetus Whiles Tarea1
        {
            lcd.locate(10,0);
            lcd.printf("%d",kp);
            if (button1.falling())
            {
                ++kp;
            }
            if (button2.falling())
            {
                --kp;
            }
        }
        if (j==2)
        {
            lcd.locate(2,1);
            lcd.printf("%d",ki);
            if (button1.falling())
            {
                ++ki;
            }
            if (button2.falling())
            {
                --ki;
            }
        }
        if (j==3)
        {
            lcd.locate(10,1);
            lcd.printf("%d",kd);
            if (button1.falling())
            {
                ++kd;
            }
            if (button2.falling())
            {
                --kd;
            }
        }
        if (j==4)  //Este if realiza dos revisiones y actua solo en este valor (SP)
        {
            j=0;
        }
        if (button4.falling())
        {
            break;     //Salir de este ciclo while
        }
    }
    /* Interaccion y avisos al usuario de sistema listo!!*/
    lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
    lcd.cls();
    lcd.printf("DATOS GUARDADOS");
    wait(2);
    lcd.cls();
    lcd.printf("INICIA EL PID");
    wait(2);
    lcd.cls();
    /* Imprimir los labels de algunas variables y parametros  de Control en Ejecucion */
    lcd.printf("Er%g",err);
    lcd.locate(8,0);
    lcd.printf("Me%g",PV);
    lcd.locate(0,1);
    lcd.printf("SP%d",sp);
    lcd.locate(8,1);
    lcd.printf("Co%g",pid);
    /*Ziegler–Nichols_method*/
    /*kp=((kp*3.3)/(kp*4.5));
    ki=2*kp;
    kd=kp/8*/;
    wait(.5);
    
    /* Ciclo while contiene el codigo especifico rutiona del PID*/
    while (1)
    {
        /* pilas con leer el puerto analogo y asignarlo a med*/
        PV = AI.read();
        PV =PV*1000;
        err =sp-PV;
        err=err/100;
        ap=kp*err;  //Proporcional incremento en funcion del error Parte P
        ai=(ki*err)+ai; //Acumula los errores Parte I
        ad=kd*(err-err_v); // tiene en cuenta el delta del error Parte D
        pid=ap+ai+ad; // comentar esta y ponerla despues de comentar los ifs
        if (ai>999)
        {
            ai=1000;
        }
        else if (pid<0)
        {
            pid=0;
        }
        AO.write(pid/1000);
        if(flag==0)
        {
            t.start();
            flag=1;
        }
        
        //AO=pid;
        if (t>0.3)
        {
        /* Imprimir algunas variables y parametros  de Control en Ejecucion */
            lcd.locate(2,0);
            printf("%g",err);
            lcd.locate(2,1);
            printf("%d",sp);
            lcd.locate(10,0);
            printf("%g",PV);
            lcd.locate(10,1);
            printf("%g",pid);
            t.reset();
            flag=0;
            wait(.3);
         }
     
        err_v = err;
       
        
    }


}


