#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "sensor_bar.h"

I2C i2c(I2C_SDA, I2C_SCL);
Adafruit_SSD1306_I2c oled(i2c,D2);

int values[NUM_SENSORS]={0,100,200,300,400,500,600,700,700,600,500,400,300,200,100,0};

DigitalOut greenLed(D13);



bool oledConnected = false;

int main(){
    
    if (!i2c.write(SSD_I2C_ADDRESS, NULL, 0)) { 
        printf("OLED SSD1306 was found\n");
        oledConnected = true;   
    }
    
    if(oledConnected) {
        oled.begin();
        oled.drawBitmap(0,0,lineFollowerLogo,128,64,1);
        oled.display();
    }
    else printf("OLED SSD1306 wasn't found\n");
    wait(1.0);
    
    if(oledConnected){
        oled.clearDisplay();   
        showSensors(values,0,700);
    }
    
    while(true){
        greenLed=1;
        wait(0.25);
        greenLed=0;
        wait(0.25);
    }   
}
