#include "sensor_bar.h"

DigitalOut led(S0);

extern Adafruit_SSD1306_I2c oled;

void initialize(void){
    led = 1;   
}


void showSensors(int values[NUM_SENSORS],int minValue,int maxValue){
    int i;
    oled.clearDisplay();

    oled.setTextCursor(20,Y_SHOW_INIT+BAR_SIZE+2);
    oled.printf("Min=%d Max=%d",minValue,maxValue);
    
    for(i=0;i<16;i++)   oled.drawRect(i*BASE_SIZE+X_SHOW_INIT,Y_SHOW_INIT,BASE_SIZE-1,BAR_SIZE,1);
        
    for(i = 0;i<16;i++){
        int val = mapfloat(values[i],minValue,maxValue,0,BAR_SIZE);
        int pos = Y_SHOW_INIT+(BAR_SIZE-val);
        oled.fillRect(i*BASE_SIZE+X_SHOW_INIT,pos,BASE_SIZE-1,val,1);
    }
    oled.display();  
}
