#include "beep_sound.h"
#include "math.h"
#include <queue>


beep_sound::beep_sound(PinName pwm)
{
    frequency = 0;
    playing = false;
    teishi = false;
    m_pwm = new PwmOut(pwm);
    m_pwm->write(0.0f);
}

beep_sound::~beep_sound()
{
    delete m_pwm;
}

void beep_sound::stop(){
    m_pwm->write(0.0f);
    // キューが空でなければ次の音へ 
    if(otoQue.empty() == true){
        playing = false;
    }else if(otoQue.front().time_s != -1){
        playing = true;
        beep_sound::playContinue();
    }else if(otoQue.front().time_s == -1){
        otoQue.pop();
        playing = false;
    }else{
        playing = false;
    }
}

// 音の再生
void beep_sound::NoteOn(int octave, int note)
{
    playing = true;
    frequency = frequencyTable[note] << octave;
    m_pwm->period(1.0f/(float)frequency);
    m_pwm->write(0.5f);
}

// 1音ずつ音符情報をキューに追加
void beep_sound::setGakuhu(int argOc, int argNo, float argTi)
{
    bufG.octave = argOc;
    bufG.note = argNo;
    bufG.time_s = argTi;
    otoQue.push(bufG);
}

// 休符をキューに追加
void beep_sound::setKyuhu(float argTi)
{
    bufG.octave = 10;
    bufG.note = 0;
    bufG.time_s = argTi;
    otoQue.push(bufG);
}

// 楽譜キューを再生、音停止の割り込み予約
// Timeoutの日本語リファレンスには書いていないが、
// thisを引数にしないとコンパイルエラーになるので注意
void beep_sound::playGakuhu()
{
    if(playing == true){
        while(otoQue.front().time_s != -1) {otoQue.pop();}
        otoQue.pop(); //最後のフラグを削除
            // 最後のフラグを挿入
            bufG.time_s = -1;
            otoQue.push(bufG);
        beep_sound::stop();
    }else{
            // 最後のフラグを挿入
            bufG.time_s = -1;
            otoQue.push(bufG);
        playing = true;
        beep_sound::NoteOn(otoQue.front().octave, otoQue.front().note);
        interruptStop.attach(this, &beep_sound::stop, otoQue.front().time_s);
        otoQue.pop();
    }
}
void beep_sound::playContinue()
{
    beep_sound::NoteOn(otoQue.front().octave, otoQue.front().note);
    interruptStop.attach(this, &beep_sound::stop, otoQue.front().time_s);
    otoQue.pop();
}

void beep_sound::SetFrequency(int octave, int note, bool on_off)
{
    static int preFrequency = 0;
    if(on_off == true){
        int frequency = frequencyTable[note] << octave;
        if(frequency != preFrequency){
            m_pwm->period(1.0f/(float)frequency);
            m_pwm->write(0.5f);
        }
        preFrequency = frequency;
    }else{
        m_pwm->write(0.0f);
        preFrequency = 0;
    }
}
void beep_sound::onpu(int octave, int note, float time_s)
{
    playing = true;
    beep_sound::NoteOn(octave, note);
    interruptStop.attach(this, &beep_sound::stop, time_s);
}
void beep_sound::onpu_stop(int octave, int note, float time_s)
{
    playing = true;
    beep_sound::NoteOn(octave, note);
    wait(time_s);
    m_pwm->write(0.0f);
}
void beep_sound::sinwave(float center,int speed,int width)
{
    for(float i=0.0f;i<6.28f;i+=0.01*speed)
    {
    m_pwm->period(1.0f/(center+width*(float)sin(i)));
    m_pwm->write(0.5f);
    wait_ms(2);
    }
}
void beep_sound::setwave(float frequency,float duty,float wait)
{
    m_pwm->period(1.0f/(frequency));
    m_pwm->write(duty);
    wait_ms(wait);
}


//以下サンプル音集
//引数の回数だけ鳴らす
void beep_sound::boot()
{
    beep_sound::setGakuhu(4,8,0.03);
    beep_sound::setGakuhu(0,8,0.03);
    beep_sound::setGakuhu(1,8,0.03);
    beep_sound::setKyuhu(0.14);
    beep_sound::setGakuhu(2,8,0.08);
    beep_sound::setGakuhu(3,1,0.16);
    beep_sound::playGakuhu();
}

void beep_sound::beep_right(int nTimes)
{
    for(int i=0; i<nTimes; i++){
        beep_sound::setGakuhu(3,11,0.1);
        beep_sound::setGakuhu(3,7,0.35);
        beep_sound::setKyuhu(0.1);
    }
    beep_sound::playGakuhu();
}
void beep_sound::beep_wrong(int nTimes)
{
    for (int i = 0; i < nTimes; i++) {
        beep_sound::setGakuhu(0, 12, 0.1);
        beep_sound::setKyuhu(0.1);
        beep_sound::setGakuhu(0, 12, 0.35);
        beep_sound::setKyuhu(0.1);
    }
    beep_sound::playGakuhu();
}
void beep_sound::beep_readyGo(int nTimes)
{
    //for (int i = 0; i < nTimes; i++) {
        beep_sound::onpu_stop(1,0,0.5);
        wait(0.5);
        beep_sound::onpu_stop(1,0,0.5);
        wait(0.5);
        beep_sound::onpu_stop(1,0,0.5);
        wait(0.5);
        beep_sound::onpu(2,0,1);
    //}
}
void beep_sound::beep_notif1(int nTimes){
    for (int i = 0; i < nTimes; i++) {
        beep_sound::setGakuhu(3,5,0.1);
        beep_sound::setGakuhu(3,10,0.1);
        beep_sound::setGakuhu(4,2,0.1);
    }
    beep_sound::playGakuhu();
}
void beep_sound::beep_notif2(int nTimes){
    for (int i = 0; i < nTimes; i++) {
        beep_sound::setGakuhu(1,2,0.1);
        beep_sound::setGakuhu(1,9,0.1);
        beep_sound::setGakuhu(2,2,0.2);
    }
    beep_sound::playGakuhu();
}
