#ifndef BEEP_SOUND_H
#define BEEP_SOUND_H
#include "mbed.h"
#include <queue>
struct gakuhu{
    int octave;
    int note;
    float time_s; // 長さが-1:通常ノート -2:終了フラグ
};
/*
struct beep{
    float userPeriod;
    float userWrite;
    float time_s;
}
*/
const int frequencyTable[] = {261, 277, 294, 311, 330, 349,
                                370, 392, 415, 440, 466, 494, 100};


class beep_sound
{
    public:
        beep_sound(PinName pwm);
        ~beep_sound();
        void SetFrequency(int octave, int note, bool on_off);
        void onpu(int octave, int note, float time_s);
        void onpu_stop(int octave, int note, float time_s);
        void sinwave(float center,int speed,int width);
        void setwave(float frequency,float duty,float wait);
        // 以下サンプル音集
        void boot();
        void beep_right(int nTimes);
        void beep_wrong(int nTimes);
        void beep_notif1(int nTimes);
        void beep_notif2(int nTimes);
        void beep_readyGo(int nTimes);
        // 以下並列で鳴らすための関数
        void stop();
        void setGakuhu(int argOc, int argNo, float argTi);
        void setKyuhu(float argTi);
        void playGakuhu();
        void playContinue();
        void NoteOn(int octave, int note);
    private:
        PwmOut* m_pwm;
        int frequency;
        // 以下並列で鳴らすための宣言
        queue<gakuhu> otoQue;
        gakuhu bufG;
        Timeout interruptStop;
        // 再生中にキューにsetGakuhuをさせないためのフラグ
        bool playing; // false:停止中 true:再生中
        bool teishi; // true:再生を強制停止. ノート再生時に必ずチェック.
};

#endif
