#include "mbed.h"
//********************************************************
//**  Nucleo-144 Stm32F746 and Stm32F767 bitbanging ******
//**        Port setting and pattern generation     ******
//**        Speed - Benchmark                       ******
//**          Jovan Ivković - 2016.                 ******
//**         JovanEps (jovan.eps@gmail.com).        ******
//********************************************************

DigitalOut myled(LED1);
DigitalOut PD7(PF_13);
DigitalOut PD5(PE_11); //introduce D5 pin-out it ping faster :)
DigitalOut PD13(PA_5); //introduce D13 pin-out
Serial pc(USBTX, USBRX);
Timer timer;

void Pinging()
{
    int i, vreme = 0, loop_vreme=0, noop=0;
    while(1) {
        // Pattern and port setting speed benchmark
        timer.start();
        // Measure loop and value setting time for 1k runs
        loop_vreme = timer.read_us();
        for ( i = 0; i <= 999; i++ ) {
            noop = i; 
        }
        // -----
        loop_vreme = timer.read_us() - loop_vreme;
        timer.reset();
        // Measure 10 bit sequence pattern
        vreme = timer.read_us();
        for ( i = 0; i <= 999; i++ ) {
            PD5 = 1; // D5 go low 1 go LOW in next 69..75ns as Tf propagates signal on osciloscope
            PD5 = 1; // D5 go low 2
            PD5 = 1; // D5 go low 3
            PD5 = 0; // D5 go inv-high on SN74vhc14 - >1.6..2.4V < 1.75ns
            PD5 = 1; // D5 go low 5
            PD5 = 1; // D5 go low 6
            PD5 = 1; // D5 go low 7
            PD5 = 1; // D5 go low 8
            PD5 = 1; // D5 go low 9
            PD5 = 1; // D5 go low 10
        }
        vreme = timer.read_us() - vreme;
        wait_us(0.2);
        pc.printf("Port set time (single)... %6.2f ns \t tested on for: %d runs \n", ( float ) ( vreme - loop_vreme ) / 10, i * 10 ); //1000x10=10k sets of PD5 div 10 for ns
        pc.printf("\n %d \n\n", noop+1);
        timer.stop();

        /*  // Alternative
                while(1) {
        PD5 = 0; // D5 go low 1
        PD5 = 0; // D5 go low 2
        PD5 = 0; // D5 go low 3
        PD5 = 1; // D5 go inv-low on 74vhc14 - <0.6v..0.9V < 1.6ns
        PD5 = 0; // D5 go low 5
        PD5 = 0; // D5 go low 6
        PD5 = 0; // D5 go low 7
        PD5 = 0; // D5 go low 8
        PD5 = 0; // D5 go low 9
        PD5 = 0; // D5 go low 10
        wait_us(0.3);
        */
        //pc.printf("\n");
    }
}

int main()
{
    myled = 1; // LED is ON - working
    pc.baud(115200);
    //pc.baud(921600);      // Max garanted UART/seriall speed
    pc.printf("Starting...\n");
    wait(0.2); // 200 ms

    //NVIC_DisableIRQ(XXX); // Disable NVIC interrupt;
    Pinging();         //Call of Pinging methode

    /*
    while(1) {
      //  PD7 = 1; // D7 go high in Tr ~69..75ns
        //PD13 = 1; // D13 go high has delay of
      //  myled = 1;

        PD5 = 0; // D5 go high
        //wait(0); // 1ns - exclude, we need as fast as we can get
      //  PD7 = 0; // D7 go low in next 69..74ns
        //PD13 = 0; // D13 go high
      //  PD7 = 1;
        //PD13 = 1; // D13 go high
        PD5 = 0;
      //  PD13 = 0; // D13 go high
        //myled = 0;
        PD5 = 0; // D5 go low
        PD5 = 1; // D5 go inv-high on 74vhc14 - 1v
        PD5 = 0; // D5 go low
        PD5 = 1; // D5 go inv-high on 74vhc14 -2v
        PD5 = 0; // D5 go low 2v
        PD5 = 1; // D5 go inv-high on 74vhc14 - 2v
        PD5 = 0; // D5 go low 2v
        PD5 = 1; // D5 go inv-high on 74vhc14 - 3v
        PD5 = 0; // D5 go low 3v
        //v4 111010101010101 4-low lead and 6-inv-peek
        PD5 = 1; // D5 go inv-high on 74vhc14 - 4v
        PD5 = 0; // D5 go low 4v
        PD5 = 1; // D5 go inv-high on 74vhc14 - 4v
        PD5 = 0; // D5 go low 4v
        //wait(0);// 1nsec - exclude, we need as fast as we can get

        }
    */
}
