#include "mbed.h"
//********************************************************
//**               ARM Cortex M7 MCU                ******
//**   ST Nucleo-144 Stm32F746 and Stm32F767 MCU    ******
//**   Newton's approximation - Benchmark based on  ******
//**   Steve Curd Adruino IDE code                  ******
//**          Jovan Ivković - 2017.                 ******
//**         JovanEps (jovan.eps@gmail.com).        ******
//********************************************************

DigitalOut myled(LED1);
//DigitalOut PD13(PA_5);  //introduce D13 pin-out
DigitalIn PD8(PF_12);  //introduce D8  *-Clear port
Serial pc(USBTX, USBRX);
Timer timer;

#define ITERATIONS 10000000L    // number of iterations 100k-10M
#define FFLASH 1000000            // blink LED every 100k-1M iterations

//#include <TM1638.h>           // include the display library

// TM1638 module(DIO, CLK, STB0)
//TM1638 module(8, 9, 7);

//*********************************
//**         MAIN block          **
//*********************************
int main()
{
    while(true) {
        unsigned long start, ttime;
        unsigned long niter = ITERATIONS;
        int LEDcounter = 0;
        bool alternate = false;
        long i, count = 0;
        double x = 1.0;
        double temp, pi = 1.0;

        pc.printf(" \n Beginning  %d",niter );
        pc.printf(" \n iterations...");
        pc.printf("\n");

        timer.start();
        start = timer.read_ms();

        for ( i = 2; i < niter; i++) {
            x *= -1.0;
            pi += x / (2.0f * (float) i - 1.0f);
          // /*
            if (LEDcounter++ > FFLASH) {
                LEDcounter = 0;
                if (alternate) {
                    myled = 1;
                    alternate = false;
                } else {
                    myled = 0;
                    alternate = true;
                }  
                temp = (float) 40000000.0 * pi;

                //module.setDisplayToDecNumber( temp, 0x80);
            }
          //*/           
        }
        ttime = timer.read_ms() - start;

        pi = (double) pi * 4.0;

        pc.printf("# of trials = %d \n", niter);
        pc.printf("\n\n");
        pc.printf("Estimate of pi = %6.10f 10 \n" , pi);
        pc.printf("Time:   %d ms \n", ttime);
        printf("state: %d \n", alternate);

        timer.stop();
        wait(1);
    }
}