//************************************************************
//**   Benchmark Sute based on Arduino bench.           ******
//**  adapted and mod. for ARM Cortex-M7 ST Nucleo-144  ******
//**  Stm32F767 and STM32F746 MCU's by                  ******
//**           Jovan Ivkovic 2016.                      ******
//**         JovanEps (jovan.eps@gmail.com).            ******
//************************************************************
#include "mbed.h"
#include "STM32F4_RNG.h"
//DigitalOut myled(LED1);
PwmOut PD13(PA_5); //PWM Out to simulate Arduino Analog.Write
//AnalogIn analog_value(A0);
AnalogIn analog_value(PA_3);
AnalogOut DACout(PA_4); //Full DAC - analog out (write)
Serial pc(USBTX, USBRX);
DigitalOut PD7(PF_13);  //introduce D7 pin-out *-Clear port it ping faster :)
DigitalIn PD8(PF_12);
DigitalInOut PD5(PE_11);
Timer timer;            //Timer

#include <math.h>
#define delay   wait_ms
#define delayMicroseconds   wait_us
#define millis()  timer.read_ms()
#define digitalWrite    DigitalOut
#define HIGH    1
#define LOW    0

// Arduino Speed Test Benchmarking Program
// Original Program Credit: Arduino.cc
// Modified By: Dan Watson
// synchannel.blogspot.com
// 1-29-2015

// Modified By: Chester Lowrey
// easybotics.com hilo90mhz.com
// 2016-12-1

// This sketch is the speed test portion of the Arduino Show Info program
// http://playground.arduino.cc/Main/ShowInfo

// Certain tests may not compile/run for all boards. Comment them out as necessary:
//  * analogReference()
//  * dtostrf()
//  * bitSet()
//  * y |= (1<<x)

// For the Arduino Zero, "Serial." needs to be "SerialUSB.". A find and replace is the easiest way
// to fix this. The program may also run in forked IDEs (such as Mpide for the chipKIT boards).

// All configuration options listed below for reference

// PIN_1 is used for digitalRead
// PIN_2 is used for digitalWrite / pinMode / analogWrite (PWM)
// Analog read is hardcoded to 0/1

#define noTitle        // define to remove titles - easier to paste results into comparison spreadsheet
//#define noAnalog       // define to remove analog read/write for ICs without this function
#define noAnalogRef    // define to remove analogRef test that some cores do not support 
//#define noDtostrfTest  // define to remove the dtostrf test that some cores do not support
//#define noBvTest       // define to remove bv test that some cores do not support
//#define USBserialWait  // define to force the main sketch to wait for USB to Serial connection - needed on some native serial boards
//#define noLtoaTest     // define to remove Itoa test that some cores do not support

// Uncomment only one of the below configurations for your specifc board, or make a new one

/*
// Arduino ATMEGA328
#define PIN_1 3
#define PIN_2 4
*/

/*
// Arduino Leonardo
#define PIN_1 2
#define PIN_2 3
#define noBvTest
#define USBserialWait
*/


// Nucleo STM32F103RB - not tested yet /WE DO NOT USE THOSE SETINGS
#define PIN_1 12
#define PIN_2 13
#define noAnalog
#define noBvTest
#define noLtoaTest

/*
// Arduino Due
#define PIN_1 2
#define PIN_2 3
#define noDtostrfTest
#define noBvTest
#define USBserialWait
*/

/*
// Arduino Zero Pins
#define PIN_1 2
#define PIN_2 3
#define noBvTest
#define noDtostrfTest
#define USBserialWait
*/

/*
// ESP8266 Pins
#define PIN_1 4
#define PIN_2 5
#define PIN_3 12
*/

/*
// ESP32 Pins
#define PIN_1 25
#define PIN_2 26
#define PIN_3 27
#define noAnalog
*/

/*
// NRF52/51 Pins
#define PIN_1 17
#define PIN_2 18
#define PIN_3 19
#define noDtostrfTest
#define noBvTest
*/

void setup()
{
    //Serial.begin(9600);
    pc.baud(9600);

    /*
    #ifdef USBserialWait
     while (!Serial) {
       ; // wait for serial port to connect. Needed for native USB
     }
    #endif


     pinMode(PIN_1, OUTPUT);
     pinMode(PIN_2, INPUT);

     pc.printfln("Speed Test will begin momentarily.");
     pc.printfln("");

     wait_ms(1000);

     speedTest();
     */
}

void speedTest(void)
{
    register int i,j;
    volatile unsigned char c1,c2;
    volatile int v;
    volatile long l1,l2;
    volatile float f1,f2;
    int p,q;
    long int r;
    unsigned long m,n;
    float d, overhead;
    char buffer[30];
    int digitalRead;
    float meas; //Analog readings
#define F_CPU 216000000
#define DEC 10


//#ifndef noTitle
    pc.printf("\n\r");
    pc.printf("Speed test \n\r");
    pc.printf("---------- \n\r");
    pc.printf("F_CPU = ");
//#endif
    pc.printf("%d",F_CPU/1000000);
    pc.printf(" MHz \n\r");
//#ifndef noTitle
    pc.printf("1/F_CPU = ");
//#endif
    pc.printf("%.4f",(1000000.0/(float)F_CPU));
    pc.printf("us \n\r");
          
    
    wait(0.5);    // Allow the Serial text to be transmitted
//#ifndef noTitle
    pc.printf("\n\r Start benchmarks");
    pc.printf("\n\r ------------------------------");
    wait_ms(70);     // Allow the Serial text to be transmitted
    pc.printf("\n\r\n\r  NOP                       : ");
//#endif
//*************************
// Start timer
//*************************
    timer.start();
//*************************
//    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<100; i++) {
        for (j=0; j<10000; j++) {
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
            asm volatile ("nop");
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;           // in micro seconds
    // Calculate overhead with 'nop' instruction per loop in microseconds
    overhead = d - (20.0 * (1000000.0/(float)F_CPU));
    d -= overhead;
    d /= 20.0;             // per instruction
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r------------------------");

//#ifndef noTitle
    pc.printf("\n\r  digitalRead               : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<10000; j++) {

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;

            digitalRead = PD8;
            digitalRead = PD8;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  digitalWrite              : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<10000; j++) {
            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;

            PD7 = HIGH;
            PD7 = LOW;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  pinMode                   : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<10000; j++) {

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);

            digitalRead = PD5.read();
            PD5.write(digitalRead);
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");



//#ifndef noTitle
    pc.printf("\n\r  multiply byte             : ");
//#endif
    c1 = 2;
    c2 = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<20; i++) {
        for (j=0; j<10000; j++) {
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
            c1 *= c2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  divide byte               : ");
//#endif
    c1 = 253;
    c2 = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<10000; j++) {
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
            c1 /= c2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  add byte                  : ");
//#endif
    c1 = 1;
    c2 = 2;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<20; i++) {
        for (j=0; j<10000; j++) {
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
            c1 += c2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  multiply integer          : ");
//#endif
    volatile int x,y;
    x = 2;
    y = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<10; i++) {
        for (j=0; j<10000; j++) {
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
            x *= y;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  divide integer            : ");
//#endif
    x = 31415;
    y = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<10000; j++) {
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
            x /= y;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  add integer               : ");
//#endif
    x = 1;
    y = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<10; i++) {
        for (j=0; j<10000; j++) {
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
            x += y;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  multiply long             : ");
//#endif
    l1 = 2;
    l2 = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<10000; j++) {
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
            l1 *= l2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  divide long               : ");
//#endif
    l1 = 2000000000L;
    l2 = 3;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<2000; j++) {
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
            l1 /= l2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  add long                  : ");
//#endif
    l1 = 500000000L;
    l2 = 123;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<4; i++) {
        for (j=0; j<10000; j++) {
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
            l1 += l2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  multiply float            : ");
//#endif
    f1 = 3.24;
    f2 = 1.25;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<10000; j++) {
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
            f1 *= f2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  divide float              : ");
//#endif
    f1 = 312645.24;
    f2 = 1.21;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<2000; j++) {
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
            f1 /= f2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  add float                 : ");
//#endif
    f1 = 9876.54;
    f2 = 1.23;
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<10000; j++) {
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
            f1 += f2;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


    /*
    //#ifndef noTitle
        pc.printf("  itoa()                    : ");
    //#endif
        wait_ms(70);     // Allow the Serial text to be transmitted
        m = timer.read_ms();
        for (i=0; i<1; i++) {
            for (j=0; j<10000; j++) {
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
                itoa(i,buffer,10);
            }
        }
        n = timer.read_ms();
        d = ((float)n - (float)m) / ((float)i * (float)j);
        d *= 1000.0;
        d -= overhead;
        d /= 20.0;
        pc.printf("%.3f",d);
        pc.printf(" us");
    */

    /*
    #ifndef noLtoaTest
        long int l = 314159L;
    //#ifndef noTitle
        pc.printf("  ltoa()                    : ");
    //#endif
        wait_ms(70);     // Allow the Serial text to be transmitted
        m = timer.read_ms();
        for (i=0; i<1; i++) {
            for (j=0; j<500; j++) {
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
                ltoa(l,buffer,10);
            }
        }
        n = timer.read_ms();
        d = ((float)n - (float)m) / ((float)i * (float)j);
        d *= 1000.0;
        d -= overhead;
        d /= 20.0;
        pc.printf("%.3f",d);
        pc.printf(" us");
    //#endif
    */

    /*
    #ifndef noDtostrfTest
    //#ifndef noTitle
        pc.printf("  dtostrf()                 : ");
    //#endif
        float d3;
        d3 = 3.14159265;
        wait_ms(70);     // Allow the Serial text to be transmitted
        m = timer.read_ms();
        for (i=0; i<2; i++) {
            for (j=0; j<1000; j++) {
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
                dtostrf (d3, 6, 2, buffer);
            }
        }
        n = timer.read_ms();
        d = ((float)n - (float)m) / ((float)i * (float)j);
        d *= 1000.0;
        d -= overhead;
        d /= 20.0;
        pc.printf("%.3f",d);
        pc.printf(" us");
    #endif
    */

//**************************
//****      Randomize
//**************************
    STM32F4_RNG rnd;
    unsigned long num;
//#ifndef noTitle
    pc.printf("\n\r  random()                  : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<2; i++) {
        for (j=0; j<1000; j++) {
            //r=random(-2147483647,2147483647);
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();
            num = rnd.Get();

        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");

//#ifndef noBvTest
//#ifndef noTitle
    pc.printf("\n\r  y |= (1<<x)               : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<20; i++) {
        for (j=0; j<10000; j++) {
            //v |= _BV(12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);
            v |= (1 << 12);

        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");
    
//#endif

    /*
    //#ifndef noTitle
        pc.printf("  bitSet()                  : ");
    //#endif
        wait_ms(70);     // Allow the Serial text to be transmitted
        m = timer.read_ms();
        for (i=0; i<20; i++) {
            for (j=0; j<10000; j++) {
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
                bitSet (v, 12);
            }
        }
        n = timer.read_ms();
        d = ((float)n - (float)m) / ((float)i * (float)j);
        d *= 1000.0;
        d -= overhead;
        d /= 20.0;
        pc.printf("%.3f",d);
        pc.printf(" us");
    */

    /*
    //#ifndef noAnalogRef
    //#ifndef noTitle
        pc.printf("  analogReference()         : ");
    //#endif
        wait_ms(70);     // Allow the Serial text to be transmitted
        m = timer.read_ms();
        for (i=0; i<20; i++) {
            for (j=0; j<10000; j++) {
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
                analogReference (EXTERNAL);
                analogReference (DEFAULT);
            }
        }
        n = timer.read_ms();
        d = ((float)n - (float)m) / ((float)i * (float)j);
        d *= 1000.0;
        d -= overhead;
        d /= 20.0;
        pc.printf("%.3f",d);
        pc.printf(" us");
    //#endif
    */

//#ifndef noAnalog
//#ifndef noTitle
    pc.printf("\n\r  analogRead()              : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<1000; j++) {
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();
            meas = analog_value.read();

        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  PWM analogWrite()         : ");
//#endif
    // Using pin 13 (system led) for output.
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<10000; j++) {
            PD13 = 0.5;
            PD13 = 0.995;
            PD13 = 0.005;
            PD13 = 0.35;
            PD13 = 0.85;
            PD13 = 0.5;
            PD13 = 0.995;
            PD13 = 0.005;
            PD13 = 0.35;
            PD13 = 0.85;
            PD13 = 0.5;
            PD13 = 0.995;
            PD13 = 0.005;
            PD13 = 0.35;
            PD13 = 0.85;
            PD13 = 0.5;
            PD13 = 0.995;
            PD13 = 0.005;
            PD13 = 0.35;
            PD13 = 0.85;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");
//#endif


//#ifndef noTitle
    pc.printf("\n\r  DAC analogWrite()         : ");
//#endif
    // Using pin 13 (system led) for output.
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<10000; j++) {
            DACout = 0.5;
            DACout = 0.995;
            DACout = 0.005;
            DACout = 0.35;
            DACout = 0.85;
            DACout = 0.5;
            DACout = 0.995;
            DACout = 0.005;
            DACout = 0.35;
            DACout = 0.85;
            DACout = 0.5;
            DACout = 0.995;
            DACout = 0.005;
            DACout = 0.35;
            DACout = 0.85;
            DACout = 0.5;
            DACout = 0.995;
            DACout = 0.005;
            DACout = 0.35;
            DACout = 0.85;
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");
//#endif


//#ifndef noTitle
    pc.printf("\n\r  wait_ms(1)                  : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<100; j++) {
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
            wait_ms(1);
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  wait_ms(100)                : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<2; j++) {
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
            wait_ms(100);
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  wait_us(2)      : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<30; i++) {
        for (j=0; j<1000; j++) {
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
            wait_us(2);
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  wait_us(5)      : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<5; i++) {
        for (j=0; j<1000; j++) {
            //pc.printfln ("Working");
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
            wait_us(5);
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");


//#ifndef noTitle
    pc.printf("\n\r  wait_us(100)    : ");
//#endif
    wait_ms(70);     // Allow the Serial text to be transmitted
    m = timer.read_ms();
    for (i=0; i<1; i++) {
        for (j=0; j<1000; j++) {
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
            wait_us(100);
        }
    }
    n = timer.read_ms();
    d = ((float)n - (float)m) / ((float)i * (float)j);
    d *= 1000.0;
    d -= overhead;
    d /= 20.0;
    pc.printf("%.3f us \n\r",d);
    pc.printf("\n\r");

    //*************************
    //**    Stop timer      ***
    //*************************
    timer.stop();
    //*************************
    pc.printf("-----  END --------");
    pc.printf("-------------------");
    wait(0.3);
}

//*********************************
//**         MAIN block          **
//*********************************
int main()
{
    setup();
    do {
        pc.printf("\n\r Speed Test will begin momentarily \n\r");
        pc.printf("\n\r");
        wait(0.3);
        speedTest();
        wait(3);
    } while (true);
}
