//********************************************************
//**  Nucleo-144 Stm32F746 and Stm32F767 benchmark  ******
//**        DP, SP and Int Arithemtic ops.          ******
//**  modified from ddown post at Arduino for STM32 ******
//**  github.com/ddrown/benchmark.c (Arduino IDE)   ******
//**                     by                         ******              
//**          Jovan Ivković - 2016.                 ******
//**         JovanEps (jovan.eps@gmail.com).        ******
//********************************************************
#include "mbed.h"
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Timer timer;

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
/* the following is optional depending on the timing function used */
#include <time.h>


#define REDO_COMPUTATIONS 10
struct results {
  uint32_t doubletime;
  uint32_t floattime;
  uint32_t inttime;
};

#define MAX_LOOPS 512
double MyDoubles[MAX_LOOPS];
double a_d = 12345.67, b_d = 54321.11;
float MyFloats[MAX_LOOPS];
float a_f = 67890.12, b_f = 8756451.17;
int Myints[MAX_LOOPS];
int a_i = 581674411, b_i = 18714;

//****************************************
uint32_t micros ()
{
//****************************************
    // uint32_t usec = timer.read_us();
    //return usec;
    return timer.read_us();
}

//****************************************
void math_add (struct results *r) {
//****************************************
  uint32_t t, c, l;
  
  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyDoubles [ l ] = double ( a_d + b_d * double ( l ) );
    }
  }
  r->doubletime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyFloats [ l ] = float ( a_f + b_f * float ( l ) );
    }
  }
  r->floattime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      Myints [ l ] =  a_i + b_i * l;
    }
  }
  r->inttime = micros () - t;
}

//****************************************
void math_sub (struct results *r) {
//****************************************  
  uint32_t t, c, l;
  
  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyDoubles [ l ] = double ( a_d - b_d * double ( l ) );
    }
  }
  r->doubletime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyFloats [ l ] = float ( a_f - b_f * float ( l ) );
    }
  }
  r->floattime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      Myints [ l ] =  a_i - b_i * l;
    }
  }
  r->inttime = micros () - t;
}

//****************************************
void math_mul (struct results *r) {
//****************************************
  uint32_t t, c, l;
    
  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyDoubles [ l ] = double ( a_d * b_d * double ( l ) );
    }
  }
  r->doubletime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyFloats [ l ] = float ( a_f * b_f * float ( l ) );
    }
  }
  r->floattime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      Myints [ l ] =  a_i * b_i * l;
    }
  }
  r->inttime = micros () - t;
}

//****************************************
void math_div (struct results *r) {
//****************************************
  uint32_t t, c, l;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyDoubles [ l ] = double ( a_d / b_d * double ( l ) );
    }
  }
  r->doubletime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      MyFloats [ l ] = float ( a_f / b_f * float ( l ) );
    }
  }
  r->floattime = micros () - t;

  t = micros ();
  for ( c = 0 ; c < REDO_COMPUTATIONS ; c ++ )
  {
    for ( l = 0 ; l < MAX_LOOPS ; l ++ )
    { 
      Myints [ l ] =  a_i / b_i * l;
    }
  }
  r->inttime = micros () - t;
}

//****************************************
void bench_loop() {
//****************************************

  struct results add_ops, sub_ops, mul_ops, div_ops;

  math_add(&add_ops);
  math_sub(&sub_ops);
  math_mul(&mul_ops);
  math_div(&div_ops);

  pc.printf("\n\n");
  pc.printf("\n     FUNCTION            DOUBLE         SINGLE         INT");
  
  pc.printf("\n Time - ADD (us/512) :\t ");
  pc.printf( "%0.1f", ( float ) add_ops.doubletime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) add_ops.floattime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf("%0.1f", ( float ) add_ops.inttime / REDO_COMPUTATIONS );
  pc.printf("\n");
  
  pc.printf("\n Time - SUB (us/512) :\t ");
  pc.printf( "%0.1f", ( float ) sub_ops.doubletime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) sub_ops.floattime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) sub_ops.inttime / REDO_COMPUTATIONS );
  pc.printf("\n");

  pc.printf("\n Time - MUL (us/512) :\t ");
  pc.printf( "%0.1f", ( float ) mul_ops.doubletime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) mul_ops.floattime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) mul_ops.inttime / REDO_COMPUTATIONS );
  pc.printf("\n");

  pc.printf("\n Time - DIV (us/512) :\t ");
  pc.printf( "%0.1f", ( float ) div_ops.doubletime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) div_ops.floattime / REDO_COMPUTATIONS );
  pc.printf("\t\t");
  pc.printf( "%0.1f", ( float ) div_ops.inttime / REDO_COMPUTATIONS );
  pc.printf("\n");
  
  wait(1);
}

//*********************************
//**         MAIN block          **
//*********************************
int main()
{
    pc.baud(57600);
    
    pc.printf("\n My Benchamrk ...");
    pc.printf("Beginningbenchmark at ");
    pc.printf("default 216 MHz ...\n");
    pc.printf("\n\n");   
           
    while(1)
    {
        myled=1;
        timer.start();
        
        bench_loop(); //Call of banch method
        
        pc.printf(" kraj \n");
        myled=0;
        timer.stop();
        
    }
}