#include "mbed.h"
#include "FastIO.h"
#include "FastPWM.h"

FastOut<LED1> led;

//Pin 29 and 30 are connected to pin 21
FastIn<p29> CAP_2_1_input;
FastIn<p30> CAP_2_0_input;
FastPWM pwm(p21);


Serial pc(USBTX, USBRX); // tx, rx

#define TIM2CR0 LPC_TIM2->CR0
#define TIM2CR1 LPC_TIM2->CR1

//void _cap_2_1_falling() {
  //  pc.printf("Interrupt: %X\n", LPC_TIM2->IR);
    //led = 1;
//}

int main()
{
    
    unsigned int ticks = 226;
    
    // This signal should give a manchester encoded 101010101
    pwm.period_ticks(ticks);
    pwm.pulsewidth_ticks(ticks / 2);
    
    // Setup TIM2
    
    // SC
    LPC_SC->PCONP |= (1<<22);               // Power on the Timer2
    LPC_SC->PCLKSEL1 &= ~(3<<12);           // Select CCLK/4 for TIM2 (whipes previous clock setting)
    LPC_SC->PCLKSEL1 |= (1<<12);            // Select CCLK for TIM2
    
    // CCR
    LPC_TIM2->CCR |= (3 << 1);  // Set CAP2.0 on falling edge with interrupt
    LPC_TIM2->CCR |= (1 << 3);  // Set CAP2.1 on rising edge
       
    pc.printf("CCR: %X\n", LPC_TIM2->CCR);

    // TCR
    LPC_TIM2->TCR = 0x0002;                  // Reset TIM2
    LPC_TIM2->TCR = 0x0001;                  // Enable TIM2
    
    bool buffer [16];
    int bits = 0;
        
    //NVIC_DisableIRQ(TIMER2_IRQn);
    //NVIC_SetVector(TIMER2_IRQn, (uint32_t)&_cap_2_1_falling);
    //NVIC_EnableIRQ(TIMER2_IRQn);
    
    while(1) {        
        
        //pc.printf("Interrupt: %X\n", LPC_TIM2->IR);

        // Poll CRO (falling edge) intterupt
        if (LPC_TIM2->IR & (1 << 4)) {
            
            led = 1;
            
            wait(100);
            
            led = 0;
            
            int diff = (TIM2CR0 - TIM2CR1) % 0xFFFFFFFF;
            
            if (diff > 90 && diff < 136) {          // Check if diff is equal to T=1/848kHz with 20% error
                // bit transition                

                if (bits == 0) {                     // Start of sequence
                    buffer[0] = 1;
                } else {
                    buffer[bits] = !buffer[bits-1];
                }
                
                pc.printf("Trasition: %u\n", diff);
                
            } else if (diff > 45 && diff < 68) {    // Check if diff is equal to T/2
                // repeat last bit
                
                if (bits == 0) {                     // Start of sequence
                    buffer[0] = 1;
                } else {
                    buffer[bits] = buffer[bits-1];
                }
                
                pc.printf("Repeat: %u\n", diff);

            } else {
                // error, default to 1 
                pc.printf("Error: %u\n", diff);
            }
            
            bits = bits + 1 % 16;
            
            LPC_TIM2->IR |= (1 << 4);               // Clear IR by writing a one
                     
        }
        
//        if (bits == 0) {
//            
//            for (int i = 0; i< 16; i++) {
//                pc.printf("%u", (int) buffer[i]);
//            }
//            
//            pc.printf("\n");
//
//        }
        
//        // Poll CRO (rising edge) intterupt
//        if (LCP_TIM2-IR != (1 << 5)) {
//            
//            int diff = (TIM2CR1 - TIM2CR2) % 0xFFFFFFFF;
//
//            // Do checks
//            
//            // End checks
//            
//            
//            LCP_TIM2->IR &= ~(1 << 5);
//        }
                
    
    
    }
    
}
