#include "mbed.h"
 
Serial pc(USBTX,USBRX);
 
 
 
AnalogIn s11(p17);
AnalogIn s12(p18);
AnalogIn s13(p19);
AnalogIn s14(p20);
 
DigitalIn resetb(p16);
 
BusOut led(p25, p26, p27, p28);
 
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
 
DigitalOut door1(p21), door2(p22), door3(p23), door4(p24);
DigitalOut door5(p25), door6(p26), door7(p27), door8(p28);
 

 
float ain1;
float ain2;
float ain3;
float ain4;
float value;
int who; 
 
void alarm(float value, int who);
void sloyfe1();
void sloyfe2();
void sloyfe3();
void sloyfe4();
void blink();
void printV();
 
 
//Ticker ticker1;
Ticker slf1;
Ticker slf2;
Ticker slf3;
Ticker slf4; 
Ticker blinkON;
 
int main ()
{
    led1 = 1;
    //ticker1.attach(&printV, 0.7);
    slf1.attach(&sloyfe1, 0.7);
    slf2.attach(&sloyfe2, 0.7);
    slf3.attach(&sloyfe3, 0.7);
    slf4.attach(&sloyfe4, 0.7);
    
    while (1)
    {    
        
        if (resetb == 1)
        {
            led1 = led2 = led3 = led4 = 0;
            led = 0;
            blinkON.detach();
        }
        
        
        
        
    }
}
 
 
/*void printV()
{
    pc.printf ("ain1 = %f\n\r", s11 * 3.3);
    pc.printf ("ain2 = %f\n\r", s12 * 3.3);
    pc.printf ("%f\n\r", s13 * 3.3);
    pc.printf ("%f\n\r", s14 * 3.3);
    
}*/

void sloyfe1()
{ 
    ain1 = (s11 * 3.3);
    
    if (ain1 > 2.33 && ain1 < 2.28)          //Vanlig state 
    {
        pc.printf("OK");
    }
    else
    {
        alarm(ain2, 2);
    }
}

void sloyfe2()
{ 
     ain2 = (s12 * 3.3);
    
    if (ain2 > 2.33 && ain2 < 2.28)          //Vanlig state 
    {
        pc.printf("OK");
    }
    else
    {
        alarm(ain2, 2);
    }
}

void sloyfe3()
{ 
     ain3 = (s13 * 3.3);
    
    if (ain3 > 2.33 && ain3 < 2.28)          //Vanlig state 
    {
        pc.printf("OK");
    }
    else
    {
       alarm(ain3, 4); 
    }
}

void sloyfe4()
{ 
     ain4 = (s14 * 3.3);
    
    if (ain4 > 2.33 && ain4 < 2.28)          //Vanlig state 
    {
        pc.printf("OK");
    }
    else
    {
        alarm(ain4, 8);
    }
}
 
void alarm(float value, int who)
{
    if (value > 0.483 && value < 0.474)   //Dør 1 og dør 2 åpen
    {    
       pc.printf("Both doors are open in s%d\n\r", who);
       led = who;
       led3 = 1;
       led4 = 1;
       blinkON.attach(&blink, 0.1);
    }
        
    else if (value > 0.879 && value < 0.862)   //Dør 1 åpen
    {
        pc.printf("Door 1 is open in s%d\n\r", who);
        led = who;
        led3 = 1;
        blinkON.attach(&blink, 0.1);
    }
        
    else if (value > 0.736 && value < 0.721)   //Dør 2 åpen
    {
        pc.printf("Door 2 is open in s%d\n\r", who);
        led = who;
        led4 = 1;
        blinkON.attach(&blink, 0.1);
    }
        
    else if (value > 2.92 && value < 2.86)    //Dør 1 kortsluttet
    {
        pc.printf("Short Circuit at Door 1 in s%d\n\r", who);
        led = who;
        led3 = 1;
        blinkON.attach(&blink, 0.1);
        
    }
        
    else if (value > 2.58 && value < 2.53)    //Dør 2 kortsluttet
    {
        pc.printf("Short Circuit at Door 2 in s%d\n\r", who);
        led = who;
        led4 = 1;
        blinkON.attach(&blink, 0.1);
        
        
    }
        
    else                                    //Something wrong in wing 1
    {
        pc.printf("verdi stemmer ikke %f", ain1);
        blinkON.attach(&blink, 0.1);
        
    } 
}

void blink()
{
    led1 = !led1;
}
