#ifndef structures_h
#define structures_h

//Structures
//--Motor data

    struct motorDataOutputSub
    {
        int counts;
        float angle;
        float velocity;
    };
    
    struct motorDataInputSub
    {
        float PWM;
        int calibrationCounts;
    };
    
    struct motorDataCombined
    {
        motorDataOutputSub output;
        motorDataInputSub input;
    
    };
    
    struct motorStruc
    {
        motorDataCombined motor1;
        motorDataCombined motor2;
        motorDataCombined motor3;
        float dt;
        bool debug;
    };
        
    
//--PID controller settings
    struct ControllerSettings //Controller settings of the discrete TF
    {
        float A;
        float B;
        float C;
        float D;
        float E;
    };
    
//--Memory of Input/Output
    struct MemoryIO
    {
        float Ym;   //output, delayed once
        float Ymm;  //output, delayed twice
        float Xm;   //input, delayed once
        float Xmm;  //input, delayed twice
        void ShiftValues(float CurX, float CurY) //Input: Current X, current Y
        {
            Ymm = Ym; //Y delayed once to Y delayed twice
            Xmm = Xm; //X delayed once to X delayed twice 
            Ym = CurY; //Current Y to Y delayed once
            Xm = CurX; //Current X to X delayed once
        };
    };   
    
#endif