//Libraries
    #include "mbed.h"
    #include "FastPWM.h"
    #include "MODSERIAL.h"
    #include "QEI.h"
    #include "stdio.h"
    
//Homebrew libraries

    #include "structures.h"
    #include "functions.h"
    #include "global.h"


//Objects
    //LED
        DigitalOut ledb(LED_BLUE); // ledb=true & ledb=1 is led off!!
        DigitalOut ledg(LED_GREEN);
        DigitalOut ledr(LED_RED);
    //Buttons
        InterruptIn button1(SW2); //button on the side of the reset button
        InterruptIn button2(SW3); //button on the side opposite of the reset button

    //PC
        Serial pc(USBTX,USBRX);

//Variables
    enum States {MovementIdle, CalibrationIdle, Demo, Startup, CalibrationPhysical, CalibrationEMG, Move, TiltCup, FailState};
    States CurrentState; 

    volatile char ledcolor; //r is red, b is blue, g is green, t is bluegreen, p is purple
    volatile int errorCode;
    
//Ticker Timings
    const float mainLoopT = 2; //Main Loopt Ticker wait
    const float ledFlipperT = .5; //LED Flicker wait
    
//Tickers
    Ticker Main_Ticker;
    Ticker Tick_Blinky;//used for the blinking of the leds
    
    
    
        //motorStruc motorData;
    
    
//Changing LED colour depending on current state
void FlipLED(void)
{
    pc.printf("FLIPLED \r\n");
    switch(ledcolor)
    {
        case 'r':
            ledr = !ledr;
            ledg = true;
            ledb = true;
            break;
        case 'b':
            ledr = true;
            ledg = true;
            ledb = !ledb;
            break;
        case 'g':
            ledr = true;
            ledg = !ledg;
            ledb = true;
            break;
        case 't':
            ledr = true;
            ledg = !ledg;
            ledb = !ledb;
            break;
        case 'p':
            ledr = !ledr;
            ledg = true;
            ledb = !ledb;
            break;
        default:
            errorCode = 1;
            CurrentState = FailState;
    }
    pc.printf("Color %c \r\n",ledcolor);
}

// Testing Placeholder
// SW2 = button1 state changing
void Run_StateChangerButton1()
{
    switch(CurrentState)
    {
    case Startup: //From
        CurrentState = CalibrationPhysical; //To
        break; //Break from switch
    case CalibrationPhysical:
        CurrentState = CalibrationIdle;
        break;
    case CalibrationIdle:
        CurrentState = CalibrationEMG;
        break;
    case CalibrationEMG:
        CurrentState = MovementIdle;
        break;
    case MovementIdle:
        CurrentState = TiltCup;
        break;
    case TiltCup:
        CurrentState = MovementIdle;
        break;
    case Move:
        CurrentState = MovementIdle;
        break;
    }
}

// Testing Placeholder
// SW3 = button2 state changing
void Run_StateChangerButton2(void)
{
    switch(CurrentState)
    {
        case CalibrationIdle:
            CurrentState = Demo;
            break;
        case MovementIdle:
            CurrentState = Move;
            break;
        case TiltCup:
            CurrentState = MovementIdle;
            break;
    }
}

//State functions
void Run_Demo(void)
{
    pc.printf("Starting Demo ...\r\n");
}

void Run_MovementIdle(void)
{
    pc.printf("Starting Idle ...\r\n");
}

void Run_CalibrationIdle(void)
{
    pc.printf("Starting Calibration Idle ...\r\n");
}

void Run_Startup(void)
{
    pc.printf("Starting Startup ...\r\n");
}

void Run_CalibrationPhysical(void)
{
    pc.printf("Starting Calibration Physical ... \r\n");
    wait(1);
    CurrentState = CalibrationIdle;
}

void Run_CalibrationEMG(void)
{
    pc.printf("Starting Calibration EMG ... \r\n");
}

void Run_Move(void)
{
    pc.printf("Starting Move ... \r\n");
}

void Run_TiltCup(void)
{
    pc.printf("Starting Calibration TiltCup ... \r\n");
}

void Run_FailState(void)
{   
    pc.printf("Error: %i",errorCode);
}


//State Machine
void StateMachine(void)
{
    switch(CurrentState)
    {
        case Demo:
            ledcolor='t';
            Run_Demo();
            break;
        case MovementIdle:
            ledcolor='b';
            Run_MovementIdle();
            break;
        case CalibrationIdle:
            ledcolor='b';
            Run_CalibrationIdle();
            break;
        case Startup:
            ledcolor='b';
            Run_Startup();
            break;
        case CalibrationPhysical:
            ledcolor='g';
            Run_CalibrationPhysical();
            break;
        case CalibrationEMG:
            ledcolor='g';
            Run_CalibrationEMG();
            break;
        case Move:
            ledcolor='p';
            Run_Move();
            break;
        case TiltCup:
            ledcolor='t';
            Run_TiltCup();
            break;
        case FailState:
            ledcolor='r';
            Run_FailState();
            break;
        default:
            CurrentState = FailState;
            errorCode = 2;
            break;
    }
}

//Main Loop, constantly running function
void mainloop()
{
        StateMachine(); 
}

//The main function
int main()
{   
    //-Initialize
    //--Turning LEDs off
        ledr = true;
        ledg = true;
        ledb = true;
    //--Set baud
        pc.baud(115200);    
    //--Set first state
        CurrentState = Startup;
    //--Setup Buttons (Placeholder for testing)
    button1.mode(PullUp);
    button1.rise(Run_StateChangerButton1);
    button2.mode(PullUp);
    button2.rise(Run_StateChangerButton2);
    
    //-Activate Tickers
        Main_Ticker.attach(mainloop,mainLoopT);
        wait(mainLoopT);
        Tick_Blinky.attach(FlipLED,ledFlipperT);
    
    //Placeholder function call

    
    //-Constantly running function
    while(true)
    {
        
    }
}