#include "functions.h"
#include "structures.h"
#include "global.h"
#include "math.h"

float V[5] = {0,0,0,0,0};
float W[2] = {0,0};
float SUM;
float a = 0.2;

float MovingAverage(float X)
{
    for(int i = 1; i < 5; i ++)
    {
        V[i] = V[i-1];
    }
    V[0] = X;
    for(int j = 0; j < 5; j ++)
    {
        float SUM = SUM + V[j];
    }
    float Avg = SUM/5;
    
    return Avg;
}
float CurveSmoothing(float X)
{
    W[1] = W[0];
    W[0] = X;
    
    float Y = a*W[0] + (1-a)*W[1];
    
    return Y;
}

float ProcessEMG(float X)
{
    //Apply LPF and Notch Filter
    float temp = Biquad(Set_LPFEMG, Mem_LPFEMG, X);
    temp = Biquad(Set_NOTEMG, Mem_NOTEMG, temp);

    //Calculate moving average
    float Avg = MovingAverage(temp);
    //Subtract moving average
    temp = temp - Avg;
    //Take absolute value
    temp = fabs(temp);
    //Smooth ze Curve
    float Y = CurveSmoothing(temp);
    
    return Y;
}
