#include "mbed.h"
#include "ultrasonic.h"

Serial pc(USBTX, USBRX);

 void dist(int distance)
{
    //put code here to happen when the distance is changed
    printf("Distance changed to %dmm\r\n", distance);
}
 void dist2(int distance2)
{
    //put code here to happen when the distance is changed
    printf("Distance2 changed to %dmm\r\n", distance2);
}

ultrasonic mu(D8, D9, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
ultrasonic mu2(D0, D1, .1, 1, &dist2);  //Set the trigger pin to D0 and the echo pin to D1
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes 

int main()
{
    int CDistance = 0;
    int CDistance2 = 0;
    pc.baud(115200);
    mu.startUpdates();//start mesuring the distance
    mu2.startUpdates();//start mesuring the distance
    while(1)
    {
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
        mu2.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
        CDistance = mu.getCurrentDistance();
        CDistance2 = mu2.getCurrentDistance();
        pc.printf("Distance1 changed to %dmm, Distance2 changed to %dmm\r\n", CDistance, CDistance2);
        wait(0.50);
    }
}
