#include "mbed.h"

/*Macros*/
#define BAD_PARAMETER (-1)
#define OFF 0
#define ON 1
#define FALSE 0
#define TRUE 1
#define CLOSED 0
#define OPEN 1

/*Extern Variables*/


/*Extern Functions*/
////////////////////////////////////////////////////
extern bool GetPrescenceStatus();
/* GetPrescenceStatus:
Input parameters  -> void
Output parameters -> bool RoomStatus;   0-> No Prescence Detected
                                        1-> Prescence Detected
*/

////////////////////////////////////////////////////
extern bool GetDoorStatus();
/* GetDoorStatus:
Input parameters  -> void
Output parameters -> bool DoorStatus;   0-> Door Closed
                                        1-> Door Open
*/

////////////////////////////////////////////////////
extern int GetWindowStatus(int window);
/* GetWindowStatus:
Input parameters  -> int window
Output parameters -> int WindowStatus; -1-> Bad parameter or error
                                        0-> Window Closed
                                        1-> Window Open
*/

////////////////////////////////////////////////////
extern int SetLight(bool Light);
/* SetLight:
Input parameters  -> bool Light;    0-> Light is OFF
                                    1-> Light is ON

Output parameters -> int WindowStatus; -1-> Bad parameter or error
                                        0-> Light is OFF
                                        1-> Light is ON
*/

////////////////////////////////////////////////////
extern unsigned int GetPersonStatus();
/* GetPersonStatus:
Input parameters  -> void

Output parameters -> unsigned int PersonNumber; 0 - 4294967296.
*/