#ifndef SENSORS_H_
#define SENSORS_H_


#include "mbed.h"
#include "ultrasonic.h"

/*Macros*/
#define BAD_PARAMETER (-1)
#define OFF 0
#define ON 1
#define FALSE 0
#define TRUE 1
#define CLOSED 0
#define OPEN 1
#define RANGE 500


/*Function Initialization*/
//START PIR SENSOR INPUT INIT
static DigitalIn PIR1(D0);
static DigitalIn PIR2(D1);
//END PIR SENSOR INPUT INIT
//START WINDOW SENSOR INPUT
static DigitalIn W1(D2);
static DigitalIn W2(D3);
static DigitalIn W3(D4);
//END WINDOW SENSOR INPUT INIT
//START DOOR SENSOR INPUT
static DigitalIn DOORSensor(D5);
//END DOOR SENSOR INPUT INIT
//START LIGHT CONTROL OUTPUT
static DigitalOut LightControl(D6);
//END LIGHT CONTROL OUTPUT
//START LIGHT FEEDBACK INPUT
static DigitalIn LIGHTSTATUS(D8);
//END LIGHT FEEDBACK INPUT


/*Extern Functions*/
////////////////////////////////////////////////////
extern bool GetPrescenceStatus();
/* GetPrescenceStatus:
Input parameters  -> void
Output parameters -> bool RoomStatus;   0-> No Prescence Detected
                                        1-> Prescence Detected
*/

////////////////////////////////////////////////////
extern bool GetDoorStatus();
/* GetDoorStatus:
Input parameters  -> void
Output parameters -> bool DoorStatus;   0-> Door Closed
                                        1-> Door Open
*/

////////////////////////////////////////////////////
extern int GetWindowStatus(int window);
/* GetWindowStatus:
Input parameters  -> int window
Output parameters -> int WindowStatus; -1-> Bad parameter or error
                                        0-> Window Closed
                                        1-> Window Open
*/

////////////////////////////////////////////////////
extern int SetLight(bool Light);
/* SetLight:
Input parameters  -> bool Light;    0-> Light is OFF
                                    1-> Light is ON

Output parameters -> int WindowStatus; -1-> Bad parameter or error
                                        0-> Light is OFF
                                        1-> Light is ON
*/

////////////////////////////////////////////////////
extern unsigned int GetPersonStatus();
/* GetPersonStatus:
Input parameters  -> void

Output parameters -> unsigned int PersonNumber; 0 - 4294967296.
*/

////////////////////////////////////////////////////
extern bool GetLightStatus();
/* GetLightStatus:
Input parameters  -> void

Output parameters -> bool LightFeedback;    0-> Light is OFF
                                            1-> Light is ON
*/

#endif