#include "Sensors.h"

/*Functions*/

//PRESCENCE DETECTION FUNCTION
bool GetPrescenceStatus(){
    static bool RoomStatus = FALSE;   

    if(PIR1==TRUE || PIR2==TRUE)
    {
        RoomStatus = TRUE;
    }
    else
    {
        RoomStatus = FALSE;
    }
            
    return RoomStatus;
}

//DOOR STATUS FUNCION
bool GetDoorStatus(){
    static bool DoorStatus = CLOSED;   

    if(DOORSensor == TRUE)
        DoorStatus = OPEN;
    else
        DoorStatus = CLOSED;
    
    return DoorStatus;
}


//WINDOW STATUS FUNCTION
int GetWindowStatus(int window){
    static int WindowStatus = CLOSED;   

    switch(window)
    {
    case 1:
        if(W1)
            WindowStatus = OPEN;
        else
            WindowStatus = CLOSED;
        break;
    case 2:
        if(W2)
            WindowStatus = OPEN;
        else
            WindowStatus = CLOSED;
        break;
    case 3:
        if(W3)
            WindowStatus = OPEN;
        else
            WindowStatus = CLOSED;
        break;
    default:
        WindowStatus = BAD_PARAMETER;
        break;
    }
            
    return WindowStatus;
}

//LIGHT CONTROL FUNCTION
int SetLight(bool Light){
    static int LightStatus = 0;   

    switch(Light)
    {
    case 0:
        LightStatus = OFF;
        LightControl = OFF;
        break;
    case 1:
        LightStatus = ON;
        LightControl = ON;
        break;
    default:
        LightStatus = BAD_PARAMETER;
        break;
    }
    
    return LightStatus;
}

//PERSON COUNTER FUNCTIONS
static void dist(int distance)
{
    /*Void*/
}
static void dist2(int distance2)
{
    /*Void*/
}

//START ULTRASONIC INIT
ultrasonic mu(D10, D11, .1, 1, &dist);    //Set the trigger pin to D10 and the echo pin to D11
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
ultrasonic mu2(D12, D13, .1, 1, &dist2);  //Set the trigger pin to D12 and the echo pin to D13
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes 
//END ULTRASONIC INIT

unsigned int GetPersonStatus()
{
    static int CDistance = 0;
    static int CDistance2 = 0;
    static unsigned int PersonNumber = 0;
    static int flag=0;
    mu.startUpdates();//start mesuring the distance
    mu2.startUpdates();//start mesuring the distance
    
    printf("--------------------------------------------- \r\n");
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
        mu2.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
        CDistance = mu.getCurrentDistance();
        CDistance2 = mu2.getCurrentDistance();
        
        if(CDistance <= RANGE && flag == 0)
        {
            flag = 1;
            printf("Entrando %d\r\n", flag);
        }
        if(CDistance2 <= RANGE && flag == 0)
        {
           flag = 2;
           printf("Saliendo %d\r\n", flag);
        }

        switch(flag)
            {
              case 1:
                    wait(0.3);
                    CDistance2 = mu2.getCurrentDistance();
                    if(CDistance2 <= RANGE)
                    {
                       PersonNumber++;
                       printf("Entro una persona \r\n");
                    }
                    else
                    {
                        printf("No entro nadie \r\n");
                    }
                    break;
                    
                case 2:
                    wait(0.3);
                    CDistance = mu.getCurrentDistance();
                    if(CDistance <= RANGE)
                    {
                       if(PersonNumber > 0)PersonNumber--;
                       printf("Salio una persona \r\n");
                    }
                        else
                    {
                        printf("No salio nadie \r\n");
                    }
                    break;
                    
                default:

                    break;
            }
            printf("Personas adentro %d\r\n", PersonNumber);      
            printf("+++++++++++++++++++ \r\n");
            wait(0.5);
            flag = 0;
    
    return PersonNumber;
}

//LIGHT FEEDBACK FUNCION
bool GetLightStatus(){
    static bool LightFeedback = OFF;   

    if(LIGHTSTATUS == ON)
        LightFeedback = ON;
    else
        LightFeedback = OFF;
    
    return LightFeedback;
}
