#include "mbed.h"
#include "nRF24L01P.h"
#include <string>
#include <cstdlib>

Serial BT(PA_9, PA_10); // tx, rx       (pines de la comunicacion serial)

nRF24L01P my_nrf24l01p(PA_7, PA_6, PA_5, PB_0, PB_1, PA_3);       // mosi, miso, sck, csn, ce, irq (pines del modulo RF)
DigitalOut myled(PC_13);

string cadena;
char tab_control;
int Humedad, Presion,Altura,Latitud,Temperatura,Longitud;
float UTC;
float sensor[10];

int hora,minuto,segundo;
long cien_mil,diez_mil,mil,cien,diez,unidad;
char Char;


void separar_UTC(float x);
void init_bt(void);



int main() {
    init_bt();
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   7

    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    //int txDataCnt = 0;
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );      //Configurar el tamaño del buffer

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
            //BT.printf("Entered If Statement...");
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );       //Funcion de la libreria para obtener los datos recibidos
                
            tab_control=rxData[0];
            //    BT.printf("Message Received: ");
            // Display the receive buffer contents via the host serial link
          for ( int i = 0; rxDataCnt > 1; rxDataCnt--, i++ ) {

                cadena+=rxData[i+1];
            }
                
                switch (tab_control)  //Depende de los datos que lleguen se almacenanan en la variable asignada
                {
                    case 'T': Temperatura=atoi(cadena.c_str());     sensor[0]=Temperatura/100.0;          break;        
                    case 'H': Humedad=atoi(cadena.c_str());         sensor[1]=Humedad;                    break;
                    case 'P': Presion=atoi(cadena.c_str());         sensor[2]=Presion;                    break;
                    case 'A': Altura=atoi(cadena.c_str());          sensor[3]=Altura;                     break;
                    case 'L': Latitud=atoi(cadena.c_str());         sensor[4]=Latitud/1000.0;             break;
                    case 'D': Longitud=atoi(cadena.c_str());        sensor[5]=Longitud/ 100.0;            break;
                    case 'U': UTC=atoi(cadena.c_str());             sensor[6]=UTC;                        break;
                    default:  BT.printf("Fail\n");
                }
                    cadena="";
            
               
               

                
            
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled = !myled;
        }
        
                        sensor[7]=hora;     //guardar las vasriables de hora, minuto y segundo
                        sensor[8]=minuto;
                        sensor[9]=segundo;
        
                separar_UTC(UTC);
        
                 BT.printf("S");
            for(int i=0; i<=9; i++)
            {
                BT.printf("%.2f,",sensor[i]);       //Enviar a la computadora la cadena de variables
                wait_ms(1);  
                }
                BT.printf("\n");
                
    }
}

////////////////////////////////////////////////////////////////////////////////

void separar_UTC(float x){ //Separar el valor de UTC para dividir las horas, minutos y segundos
    
     cien_mil=x/100000;
     diez_mil=(x-(cien_mil*100000))/10000;
     mil=(x- (cien_mil*100000 + diez_mil*10000))/1000;
     cien=(x-(cien_mil*100000 + diez_mil*10000 + mil*1000 ))/100;
     diez=(x-(cien_mil*100000 + diez_mil*10000 + mil*1000 + cien*100))/10;
     unidad=x-(cien_mil*100000 + diez_mil*10000 + mil*1000 + cien*100 + diez*10);
     
     hora=(cien_mil*10 + diez_mil);
     minuto=(mil*10 + cien);
     segundo=(diez*10 + unidad);
    }
    

void init_bt(void)  // Iniciar la comunicacion serial para configurar la velocidad de baudaje
{
    BT.baud(115200);
  //  BT.attach(&interruption,Serial::RxIrq);

}
