#include "Sensores.h"
#include "mbed.h"
#include "Dht11.h"
#include "BMP180.h"
#include "GPS.h"
#include "nRF24L01P.h"


 Serial BT(Rx,Tx);
 Dht11 sensor(SENSOR);
 I2C i2c(SDA, SCL); //SDA,SCL
 BMP180 bmp180(&i2c);
 GPS ark(ARK_Rx, ARK_Tx);
 DigitalOut myled(LED);
 Ticker mTicker;
 nRF24L01P my_nrf24l01p(MOSI, MISO, SCK, CSN, CE, IRQ);       // mosi, miso, sck, csn, ce, irq

 
int Temperatura,Humedad, Presion, Altura, Lat, Long;
 float Longitud, Latitud, temp;
 long UTC,muestreo_sensores=0;;
 char hora,minuto,segundo;
 int count=0;
 int count_enviar=0;
 
 

char tab_control[TRANSFER_SIZE]={'T','H','P','A','L','D','U'};
char valor[TRANSFER_SIZE];
int variables[7];

 
 void ticker_callback(){
     count++;
     muestreo_sensores++;
     count_enviar++;
     
     if(count>10){
            // Temperatura=sensor.getFahrenheit();
         if( ark.sample() == 1) {
         //    myled=0;
             Latitud=ark.latitude;
             Longitud=ark.longitude;
             UTC=ark.utc+50000;
             Altura=ark.alt;
             
             }
          //   else myled=1;
         count=0;  
     }
     
     if(muestreo_sensores>200) {
       sensor.read();
       Humedad=sensor.getHumidity();
       muestreo_sensores=0;
      }
      
      if(count_enviar>5) {
        enviar_datos();
        myled=!myled;
       count_enviar=0;
      }
      
    }
 
////////////////////////////////////////////////////////////////////////////////
 void init_serial(void){
     BT.baud(115200);
     }

 void init_transmisor(void){
     
     my_nrf24l01p.powerUp();
     my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
     my_nrf24l01p.setTransmitMode();
     my_nrf24l01p.enable();
    }
 
 void init_sensores(void){
     mTicker.attach_us(&ticker_callback,10000); //(funtion(),tiempo de interrupcion(seg))
     bmp180.init();
     }
     
 void actualizar(void){
       
      bmp180.startTemperature();
      wait_ms(5); 
      if(bmp180.getTemperature(&temp) != 0) {
          //  BT.printf("Error getting temperature\n");
        }
     
      bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
      wait_ms(10);    // Wait for conversion to complete
      if(bmp180.getPressure(&Presion) != 0) {
          //  BT.printf("Error getting pressure\n");
        }
        

        
 }
 
 void enviar_datos(void){
       presion();
       sensor_dht11();
       global();
       transmitir();
     }
 
////////////////////////////////////////////////////////////////////////////////Enviar data

void presion(void){
         
        
         Temperatura=temp*100;
         variables[0]=Temperatura;
         variables[2]=Presion;
/*
       sprintf(valor,"T%06d",Temperatura);
       
       BT.printf(valor);
       BT.printf("\n");*/
      }
      
void sensor_dht11(void){
    variables[1]=Humedad;
    }
    
void global(void){
    
      Lat=Latitud*1000;
      Long=Longitud*100;
      
      variables[3]=Altura;
      variables[4]=Lat;
      variables[5]=Long;
      variables[6]=UTC;
      
}

////////////////////////////////////////////////////////////////////////////////
void transmitir(void){
          for(int i=0; i<=6; i++){
          
          sprintf(valor,"%c%6d",tab_control[i],variables[i]);
          
            // If the transmit buffer is full
            if ( TRANSFER_SIZE >= sizeof( valor) ) {
                BT.printf("Sending Message... ");
                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0,valor, TRANSFER_SIZE );
                BT.printf("Message Sent\n");
            }
        }
 }
 

 
 