// C.P. Diduch
// EE4333 Robotics Lab-3, January 18, 2014.
// Template for implementation of a PI Speed Control System
#include "InterruptIn.h"
#include "rtos.h"
#include "mbed.h"
#include "Serial.h"

// Function prototypes
void PiControllerISR(void);
void WdtFaultISR(void);
void ExtCollisionISR(void);
void PiControlThread(void const *argument);
void ExtCollisionThread(void const *argument);
void Watchdog(void const *n);
void UserInterface(void);

// Global variables for interrupt handler
int Position;
signed int u; //On Time Int

// Processes and threads
int32_t SignalPi, SignalWdt, SignalExtCollision; //Semaphores

osThreadId PiControl,WdtFault,ExtCollision;
osThreadDef(PiControlThread, osPriorityRealtime, DEFAULT_STACK_SIZE); // Declare Control as a thread/process
osThreadDef(ExtCollisionThread, osPriorityHigh, DEFAULT_STACK_SIZE); // Declare External Collision as a thread/process
osTimerDef(Wdtimer, Watchdog); // Declare a watch dog timer
//typedef enum{
// osPriorityIdle = -3, ///< priority: idle (lowest)
// osPriorityLow = -2, ///< priority: low
// osPriorityBelowNormal = -1, ///< priority: below normal
// osPriorityNormal = 0, ///< priority: normal (default)
// osPriorityAboveNormal = +1, ///< priority: above normal
// osPriorityHigh = +2, ///< priority: high
// osPriorityRealtime = +3, ///< priority: realtime (highest)
//}osPriority;

// IO Port Configuration
// Digital
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut BR1(p9); //Brake 1
DigitalOut DIR1(p10); //Direction 1

//PWM
PwmOut PW1(p22);

//Serial
Serial pc(USBTX, USBRX); // Pins (tx, rx) for PC serial channel
Serial BluetoothSerial(p28,p27);

//Interrupts
InterruptIn Bumper(p8); // External interrupt pin declared as Bumper
Ticker PeriodicInt; // Declare a timer interrupt: PeriodicInt

signed DisplayMenu(){
signed x = 0;
char Key[7] = "+00000";
        printf("\n\rEnter a Pulse Width in microSeconds (max +/-30000, include leading zeroes):");
        pc.gets(Key,7);
        x = strtol(Key,NULL,10);
        printf("\n\r Selected Pulse Width = %d us", x);
        //pc.printf("\r\n%6d", Position); // The terminal emulator may be configured to
        // store received data to a file
        Thread::wait(100); // Go to sleep for 500 ms
        return x;
}

// ******** Main Thread ********
int main() { // This thread executes first upon reset or power-on.
    PW1.period_us(20);
    BR1.write(1);
    DIR1.write(1);
    
    // Attach the address of the ExtCollisionISR to the rising edge of Bumper:
    Bumper.rise(&ExtCollisionISR);
    
    // Start execution of the threads: PiControlThread and ExtCollisionThread:
    PiControl = osThreadCreate(osThread(PiControlThread), NULL);
    ExtCollision = osThreadCreate(osThread(ExtCollisionThread), NULL);
    
    // Start the watch dog timer and enable the watch dog interrupt
    osTimerId OneShot = osTimerCreate(osTimer(Wdtimer), osTimerOnce, (void *)0);
    pc.printf("\r\n RTOS Template Program");
    
    // May prompt user for input data here:
    // Specify address of the PeriodicInt ISR as PiControllerISR, specify the interval
    // in seconds between interrupts, and start interrupt generation:
    PeriodicInt.attach(&PiControllerISR, .05);
    do {  
        u = DisplayMenu();
        printf("\n\r Memory Pulse Width: %d", u);
    }
    while(1);
    
}


// ******** Control Thread ********
void PiControlThread(void const *argument) {
    while (true) {
        osSignalWait(SignalPi, osWaitForever); // Go to sleep until, SignalPi, is received.
        //led2 = !led2; // Alive status - led2 toggles each time PiControlThread is signaled.
        if(u >= 0)
        {
            if(u>=131071) u = 131071; //Overflow protection
            PW1.pulsewidth_us(u);
            DIR1.write(1);
            }
        else if(u < 0)
        {
            if(u<-131071) u = -131071; //Overflow protection
            PW1.pulsewidth_us(u);
            DIR1.write(0);
            }
        Position = Position + 1;
        printf("\n\r Memory Pulse Width = %d", u);    
    }
}

// ******** Collision Thread ********
void ExtCollisionThread(void const *argument) {
    while (true) {
        // Go to sleep until signal, SignalExtCollision, is received:
        osSignalWait(SignalExtCollision, osWaitForever);
        led4 = 0;
    }
}

// ******** Watchdog Interrupt Handler ********
void Watchdog(void const *n) {
    led3=0; // led3 is activated when the watchdog timer times out
}

// ******** Period Timer Interrupt Handler ********
void PiControllerISR(void) {
    // Activate the signal, PiControl, with each periodic timer interrupt.
    //osSignalSet(PiControl,0x1); 
}

// ******** Collision Interrupt Handler ********
void ExtCollisionISR(void) {
    // Activate the signal, ExtCollision, with each pexternal interrupt.
    //osSignalSet(ExtCollision,0x1);
}

/*/ ******** User Interface *********
void UserInterface(void) {
    char x;
    do{
        if (pc.readable()) {
            x = pc.getc(); pc.putc(x); //Echo keyboard entry
            osTimerStart(OneShot, 2000); // Set WDT interrupt to 2s.
            led3 = 0;
        }
         (BluetoothSerial.readable()) {
            x = BluetoothSerial.getc();
            (x == 'w'){ 
                pc.printf("\r\n w pressed");
            }
            // Display variables at the terminal emulator for logging:
            pc.printf("\r\n blah blah");
            Thread::wait(500); // Wait 500 ms
            }
    }while(1);
}*/
