#include "mbed.h"
#include "AR6210.h"
// Original code: https://mbed.org/users/BlazeX/code/AR8000/
// Modified by Joram Querner for Spektrum AR6210

AR6210::AR6210() :
  ChInt0(InterruptIn(p5)), // throttle
  ChInt1(InterruptIn(p6)), // aileron
  ChInt2(InterruptIn(p7)), // elevator
  ChInt3(InterruptIn(p8)), // rudder
  ChInt4(InterruptIn(p9)), // gear
  ChInt5(InterruptIn(p10)) // aux
{}
               
void AR6210::init()
{
    Time.start();
    
    for(int i= 0; i < 6; i++) {
        LastRise[i]= 0;
        dTime[i]= 1000;
    }
    
    ChInt0.mode(PullDown);   ChInt0.rise<AR6210>(this, &AR6210::Rise0);     ChInt0.fall<AR6210>(this, &AR6210::Fall0);
    ChInt1.mode(PullDown);   ChInt1.rise<AR6210>(this, &AR6210::Rise1);     ChInt1.fall<AR6210>(this, &AR6210::Fall1);
    ChInt2.mode(PullDown);   ChInt2.rise<AR6210>(this, &AR6210::Rise2);     ChInt2.fall<AR6210>(this, &AR6210::Fall2);
    ChInt3.mode(PullDown);   ChInt3.rise<AR6210>(this, &AR6210::Rise3);     ChInt3.fall<AR6210>(this, &AR6210::Fall3);
    ChInt4.mode(PullDown);   ChInt4.rise<AR6210>(this, &AR6210::Rise4);     ChInt4.fall<AR6210>(this, &AR6210::Fall4);
    ChInt5.mode(PullDown);   ChInt5.rise<AR6210>(this, &AR6210::Rise5);     ChInt5.fall<AR6210>(this, &AR6210::Fall5);
    
    update();
}

void AR6210::update()
{
    //Rohdaten &#65533;hmen
    for(int i= 0; i<6; i++)
        RawChannels[i]= dTime[i];
    
    Throttle= map(dTime[0], 1095, 1910, 0.0, 1.0);
    Aileron= map(dTime[1], 1110, 1900, -1.0, 1.0);
    Elevator= map(dTime[2], 1100, 1900, -1.0, 1.0);
    Rudder= map(dTime[3], 1105, 1895, -1.0, 1.0);
    
    Gear= map(dTime[4], 1095, 1910, 0.0, 1.0);
    Aux= map(dTime[5], 1095, 1910, 0.0, 1.0);
}

float AR6210::map(int x, int in_min, int in_max, float out_min, float out_max)
{
    float returnValue = (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    if (returnValue < out_min)
        return out_min;
    if (returnValue > out_max)
        return out_max;

      return returnValue;
}