#pragma once
// Original code: https://mbed.org/users/BlazeX/code/AR8000/
// Modified by Joram Querner for Spektrum AR6210

// Interrupt callback
#define AR6210_RISE_FALL(Ch)\
void Rise##Ch()\
{\
    LastRise[Ch]= Time.read_us();\
}\
void Fall##Ch()\
{\
    int dT= Time.read_us() - LastRise[Ch];\
    if(dT > 900 && dT < 2100)\
         dTime[Ch]= dT;\
}


class AR6210
{
private:
    InterruptIn ChInt0;
    InterruptIn ChInt1;
    InterruptIn ChInt2;
    InterruptIn ChInt3;
    InterruptIn ChInt4;
    InterruptIn ChInt5;
    
    Timer Time;
    volatile int LastRise[6];       //Zeitpunkt der letzten steigende Flanke  
    volatile int dTime[6];          //Pulsdauer in us [1000...2000]
    
    float map(int x, int in_min, int in_max, float out_min, float out_max);
    
public:
    int RawChannels[6]; //Rohdaten [1000...2000]
    
    //Die Steuerbefehle
    float Throttle;     //0=Aus, 1=Vollgas
    float Aileron;      //-1=Links, 0=Nichts, +1=Rechts
    float Elevator;     //-1=Sinken, 0=Nichts, +1=Steigen
    float Rudder;       //-1=Links, 0=Nichts, +1=Rechts
    
    float Gear;         //-1...+1 Left Trim
    float Aux;         //-1...+1 Right Trim

    //Initialisieren
    AR6210();
    void init();
    void update();
    
    //Interrupt-Callbacks definieren
    AR6210_RISE_FALL(0);
    AR6210_RISE_FALL(1);
    AR6210_RISE_FALL(2);
    AR6210_RISE_FALL(3);
    AR6210_RISE_FALL(4);
    AR6210_RISE_FALL(5);  
};