//Uses the measured z-acceleration to drive leds 2 and 3 of the mbed

#include "mbed.h"
//accelerometer header file
#include "MMA7660.h"
//LCD screen header file
#include "C12832.h"
//include PRPC command file
#include "SerialRPCInterface.h"

//default pin connections for LCD
C12832 lcd(p5, p7, p6, p8, p11);
//default pins for accelerometer
MMA7660 MMA(p28, p27);
//
float X = 0;
float Y = 0;
float Z = 0;
float ai1=0;
float ai2=0;
int alarm1 = 0;
int alarm2 = 0;
RPCVariable<float> rpc_ai1(&ai1,"ai1");

RPCVariable<float> rpc_ai2(&ai2,"ai2");
 
RPCVariable<int> rpc_alarm1(&alarm1,"alarm1");
RPCVariable<int> rpc_alarm2(&alarm2,"alarm2");
AnalogIn pot2(p19);
DigitalOut led(LED1);
AnalogIn pot1(p20);
DigitalOut led2(LED2);

RPCVariable<float> RPCX(&X, "X");
RPCVariable<float> RPCY(&Y, "Y");
RPCVariable<float> RPCZ(&Z, "Z");
SerialRPCInterface SerieleInterface(USBTX, USBRX);
DigitalOut connectionLed(LED1);
//pwm led 1 and 2
PwmOut Zaxis_p(LED2);
PwmOut Zaxis_n(LED3);
//pwm signals for RGB LED
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

int main() { 

    //clear lcd screen
    lcd.cls();
    //update axis period
    r.period(0.001); 
    //test connection to board
    if (MMA.testConnection())
    connectionLed = 1;
        
    while(1) {
        Zaxis_p = MMA.z();
        Zaxis_n = -MMA.z();
        r = MMA.x();
        g =  MMA.y();
        b = MMA.z();
        lcd.locate(0,0);
        lcd.printf("X as : %.2f", MMA.x());
        lcd.locate(0,10);
        lcd.printf("Y as : %.2f", MMA.y());
        lcd.locate(0,20);
        lcd.printf("Z as : %.2f", MMA.z());
        X = MMA.x();
        Y = MMA.y();
        Z = MMA.z();
        ai1 = pot2;
        ai2 = pot1;
        if(pot2 > 0.3) {
            led = 1;
            alarm1 = led;
        } else {
            led = 0;
            alarm1 = led;
        }
        if(pot1 > 0.7) {
            led2 = 1;
            alarm2 = led2;
        } else {
            led2 = 0;
            alarm2 = led2;
        }      
    }

}