//library's
#include "mbed.h"
#include "TextLCD.h"
#include "ds1307.h"
#include "EthernetNetIf.h"
//#include "HTTPClient.h"
//#include "NTPClient.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
//Pin initialisatie
AnalogIn binnen(p19);//pin 19:Analog In
AnalogIn buiten(p20);//pin 20:Analog In
TextLCD lcd(p15, p16, p21, p22, p23, p24); //rs, e, d4-d7
InterruptIn knopUP(p6);//pin6:Interrupt
InterruptIn knopDOWN(p5);//pin5:Interrupt
InterruptIn knopINSTEL(p7);//pin7:Interrupt
InterruptIn knopBACK(p8);//pin8:Interrupt
DS1307 my1307(p9, p10);//pin9:sda I2C
DigitalOut relais(p30);//pin10:scl I2C
DigitalOut RGBblauw(p29);//pin29:digital out
DigitalOut RGBgroen(p28);//pin28:digital out
DigitalOut RGBrood(p27);//pin27:digital out
PwmOut Servo(p25);//p25:pwm out
Serial pc(USBTX,USBRX);//serial port:USB
/* HTTP Instellingen */
EthernetNetIf eth(                                                                  //We gaan de functie van ethernet opendoen om hierin de gewenste adressen in te kunnen gaan voegen.
    IpAddr(192,168,1,2),                                                            //Ip adres toedienen waarop de MBED verbonden word.
    IpAddr(255,255,255,0),                                                          //Subnetmasker voor de MBED.
    IpAddr(192,168,1,1),                                                            //Het IP adres waarop we gaan schrijven.
    IpAddr(192,168,1,1));                                                           //Het IP adres waarvan we gaan lezen.
    HTTPServer svr;                                                                 // Opstarten van de HTTP server met de bovenliggende eigenschappen.
/* END HTTP */
//variabelen
float i = 0;//waarde om binnentempertauur in te steken
float j = 0;//waarde om buitentemperatuur in te steken
int reftemp = 20;//referentietemperatuur
int load=0;//load program
int tellertijd =0;//uit tijdsuitlezing te geraken
int c=0;
//variabelen RTC
 int sec;
 int minu;
 int hours;
 int day;
 int date;
 int month;
 int year;
 //RTC read routine
 void test_rw(int test) {
} 
//interruptroutine: referentietemp instellen
void instellen()
{
    knopDOWN.rise(NULL);
    knopUP.rise(NULL);//interrupt disable
    wait(0.5);
    while(knopINSTEL == 0)
    {
        lcd.locate(0,0);
        lcd.printf(" Instellen Temp");
        lcd.locate(0,1);
        lcd.printf("   Temp = %iC", reftemp);//Printen ingestelde referentietemp
        if(knopUP == 1)//knopUP bediend --> reftemp +1
        {
            reftemp++;
            wait(0.4);
        }
        if(knopDOWN == 1)//knopDOWN bediend --> reftemp -1
        {
            reftemp--;
            wait(0.4);
        }
        if (reftemp == 33)//hysteresis reftemp
        {
            reftemp = 15;
        }
        if (reftemp == 14)//hysteresis reftemp
        {
            reftemp = 32;
        }
    }
}
//interruptroutine: tijdsweergave
void back()
{
    wait(0.3);
    tellertijd=0;//dit is een hulp, zodat de tijdsweergave na een bepaalde teruggaat naar het basisscherm
    lcd.cls();//LCD clead
    knopBACK.rise(NULL);
    knopUP.rise(NULL);//disable interrupt
    while(tellertijd < 50)//doorolopen wanneer knopBack NIET is ingedrukt,bij bediening uit routine
    {
        test_rw(my1307.gettime( &sec, &minu, &hours, &day, &date, &month, &year));//uitlezen tijd RTC
        //Dag uitschrijven op lcd
        if(day == 1)
        {lcd.locate(3,1);
        lcd.printf("Ma");}
        if(day == 2)
        {lcd.locate(3,1);
        lcd.printf("Di");}
        if(day == 3)
        {lcd.locate(3,1);
        lcd.printf("Wo");}
        if(day == 4)
        {lcd.locate(3,1);
        lcd.printf("Do");}
        if(day == 5)
        {lcd.locate(3,1);
        lcd.printf("Vr");}
        if(day == 6)
        {lcd.locate(3,1);
        lcd.printf("Za");}
        if(day == 7)
        {lcd.locate(3,1);
        lcd.printf("Zo");}
        test_rw(my1307.gettime( &sec, &minu, &hours, &day, &date, &month, &year));//uitlezen tijd RTC
        //Uur min sec //Dag datum maand jaar
                if(sec >= 9 && minu >= 9 && hours >= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("%d:%d:%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec <= 9 && minu >= 9 && hours >= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("%d:%d:0%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec >= 9 && minu <= 9 && hours >= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("%d:0%d:%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec >= 9 && minu >= 9 && hours <= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("0%d:%d:%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec <= 9 && minu <= 9 && hours >= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("%d:0%d:0%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec <= 9 && minu >= 9 && hours <= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("0%d:%d:0%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec >= 9 && minu <= 9 && hours <= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("0%d:0%d:%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                if(sec <= 9 && minu <= 9 && hours <= 9)
                {
                    lcd.locate(4,0);
                    lcd.printf("0%d:0%d:0%d",hours,minu,sec);
                    lcd.locate(6,1);
                    lcd.printf("%d/%d/%d",date,month,year);
                }
                wait(0.2);
                tellertijd++;
    }
}
//interruptroutine: start programma
void start()
{
    knopINSTEL.rise(NULL);
    knopBACK.rise(NULL);
    knopDOWN.rise(NULL);
    knopUP.rise(NULL);//disable interrupt
    lcd.cls();//LCD clear
    /*OPSTART ROUTINE START*/
    lcd.locate(0,0);
    lcd.printf("SYSTEM START");
    lcd.locate(0,1);
    lcd.printf("LOAD PROGRAM");
    wait(2);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("SYSTEM START");
    lcd.locate(0,1);
    lcd.printf("LOAD: %d",load);
    for(int l=0;l<=40;l++)
    {
        load = l;
        lcd.locate(0,1);
        lcd.printf("LOAD: %d",load);
        wait(0.1);
    }
    wait(1);
    for(int l=40;l<=70;l++)
    {
        load = l;
        lcd.locate(0,1);
        lcd.printf("LOAD: %d",load);
        wait(0.2);
    }
    wait(1);
    for(int l=70;l<=100;l++)
    {
        load = l;
        lcd.locate(0,1);
        lcd.printf("LOAD: %d",load);
        wait(0.2);
    }
    wait(1);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("SYSTEM START");
    lcd.locate(0,1);
    lcd.printf("PROGRAM START");
    wait(3);
    /*OPSTARTROUTINE END*/
}
//interruptroutine: programma stoppen
void afsluiten()
{
    knopUP.rise(&start);//interrupt koppelen met routine
    knopINSTEL.rise(NULL);
    knopBACK.rise(NULL);
    knopDOWN.rise(NULL);//disabel interrupt
    lcd.cls();//lcd clear
    /*AFSLUITROUTINE START*/
    lcd.locate(0,0);
    lcd.printf("SYSTEM SHUTDOWN");
    wait(2);
    relais = 0;//relais uit
    RGBrood = 0;
    RGBgroen = 0;
    RGBblauw = 0; //RGB uit
    while(knopUP == 0)
    {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("SYSTEM OFF");
        wait(0.2);
    }
    /*AFSLUITROUTINE END*/
}
/*MAIN PROGRAM*/
int main()
{
          
    wait(1);
    while(1) 
    {   EthernetErr ethErr;
        int count = 0;
        do {
         printf("Setting up %d...\n\r", ++count);
            ethErr = eth.setup();
            if (ethErr) printf("Timeout\n\r", ethErr);
         } while (ethErr != ETH_OK);

        printf("Connected OK\n\r");
        const char* hwAddr = eth.getHwAddr();

         IpAddr ethIp = eth.getIp();
            printf("IP address : %d.%d.%d.%d\n\r", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
            
            LocalFileSystem fs("webfs");
            
            svr.addHandler<SimpleHandler>("/hello");
            svr.addHandler<FSHandler>("");
            
    svr.bind(80);
    printf("Server listening\n\r");
        knopINSTEL.rise(&instellen);
        knopBACK.rise(&back);
        knopDOWN.rise(&afsluiten);//interrupts koppelen met routines(bovenaan gedeclareerd)
        i=0;
        j=0;//variabele temperatuurwaardes 0 zetten
        for(int a=0;a<5;a++)
        {
            for(int t=0;t<100;t++) 
            {
                i=i+binnen.read(); //uitlezen temp 
            }
            for(int k=0;k<100;k++) 
            {
                j=j+buiten.read(); //uitlezen temp 
            }
            wait(0.1);
        }
        i = (i*3.3)/5;
        j = (j*3.3)/5;//berekening juiste temperatuur: Waarde*3.3V/5(for lus van 5)
        lcd.cls();//lcd clear
        lcd.locate(0,0);
        lcd.printf("Binnen:%4.1fC", i);
        lcd.locate(0,1);
        lcd.printf("Buiten:%4.1fC", j);//LCD print temperaturen
        wait(1);
        pc.printf("\n\n\rTemperatuur binnen: %4.1f C",i);
        pc.printf("\n\n\rTemperatuur buiten: %4.1f C",j);
        pc.printf("\n\n\r------------------------------------------");//PC print temperaturen
        wait(0.5);
        if(i > (reftemp + 2) && i <= (reftemp +4))//Temperatuur te HOOG: reftemp >2 en reftemp <=4
        {
            wait(2);
            relais = 1;//relais aan
            RGBrood = 1;
            RGBgroen = 1;
            RGBblauw = 0;//rgb rood + groen = oranje
            wait(1);
            Servo.period_ms(20);//servo pwm periode
            Servo = (130 * 0.000511 + 0.026); // rechts-half servo
        }
        else if(i > (reftemp + 3.5))//Temperatuur te HOOG: reftemp > 3.5 (hysteresis ingebouwd)
        {
            wait(2);
            relais = 1;//relais aan
            RGBrood = 1;
            RGBgroen = 0;
            RGBblauw = 0;//rgb rood
            wait(1);
            Servo.period_ms(20);//servo pwm periode
            Servo = (160 * 0.000511 + 0.026); // rechts servo
        }
        else if(i < (reftemp - 2) && i >= (reftemp -4))//Temperatuur te LAAG: reftemp>2 & reftemp <4
        {
            wait(2);
            relais = 0;//relais uit
            RGBrood = 1;
            RGBgroen = 0;
            RGBblauw = 1;//rgb rood + blauw= paars
            wait(1);
            Servo.period_ms(20);//servo pwm periode
            Servo = (55 * 0.000511 + 0.026); // links-half servo
        }
        else if(i < (reftemp - 3.5))//Temperatuur te LAAG: reftemp>4
        {
            wait(2);
            relais = 0;//relais uit
            RGBrood = 0;
            RGBgroen = 0;
            RGBblauw = 1;//rgb blauw
            wait(1);
            Servo.period_ms(20);//servo pwm period
            Servo = (5 * 0.000511 + 0.026); // links servo
        }
        else//Temperatuur OKE: reftemp binnen hysteresis +2 & -2
        { 
            wait(1);
            relais = 0;
            RGBrood = 0;
            RGBgroen = 1;
            RGBblauw = 0;//rgb groen
            wait(1);
            Servo.period_ms(20);//servo pwm period
            Servo = (90 * 0.000511 + 0.026); // 0-positie servo
        }
        wait(1);
        printf("Doorlopen\r\n");
        FILE *fp = fopen("/webfs/mydata.htm","w");
        fprintf(fp,"<HTML>\r\n");                                               //HTML opstarten
        fprintf(fp,"<HEAD>\r\n");                                               //Head van het bestand open zetten.
        fprintf(fp,"<script type=\"text/javascript\">window.setTimeout(function(){ document.location.reload(true); }, 3000);</script>");//Script laden  
        fprintf(fp,"<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css\">");//Stijl van het document laden
        fprintf(fp,"<style>\r\n");//De style toepassen die is opgevraagd          
        fprintf(fp,"tbody {background:#FF8866;}");//Achtergrond veranderen van kleur
        fprintf(fp,"</style>\r\n");//De aangemaakt stijl terug sluiten
        fprintf(fp,"</HEAD>\r\n");//Sluiten van de HEAD
        fprintf(fp,"<BODY>\r\n");//Sluiten van de BODY
        fprintf(fp,"<div class=\"container\">\r\n");      
        fprintf(fp,"<div class=\"panel panel-success\">");
        fprintf(fp,"<table class=\"table\">");//Aanmaken van tabel
        fprintf(fp,"<thead><tr><th>binnen</th><th>buiten</th></tr></thead>"); 
        fprintf(fp,"<tbody><tr><td>%.1f &deg;C</td>",i);
        fprintf(fp,"<td>%.1f &deg;C</td></tr></tbody></table></div>",j);
        fprintf(fp,"</div>");
        printf("Variabelen printen\r\n");
        fprintf(fp,"</BODY>\r\n");
        fprintf(fp,"</HTML>\r\n");
        printf(" %f + %f",i,j);
        printf("Sessie stoppen \r\n"); 
        fclose(fp);
        wait(1);
    }
}
