#include "mbed.h"
//#include "General.hpp"
//#include "rtos.h"
#include "Pins.h"
#include "VL6180.hpp"
#include <vector>

#define DEBUG_TOF
#ifdef DEBUG_TOF
Serial debug_term(SERIAL_TX, SERIAL_RX);
#endif
//
////#define ROS_TOF
int Global_TOF_Ranges[num_VL6180];
bool TOF_Range_Flag;
Mutex Global_TOF_Range_Mutex;

BusOut SHDN_Pins(PC_9, PC_11, PD_2, PG_3);

I2C i2c(I2C_SDA, I2C_SCL); // Set up I²C on the STM32 NUCLEO-401RE

///////////////////////////////////////////////////////////////////
// Split 16-bit register address into two bytes and write
// the address + data via I²C
///////////////////////////////////////////////////////////////////

void WriteByte_Uninitialized(wchar_t reg, char data, char addr) {    
    char data_write[3];
    data_write[0] = (reg >> 8) & 0xFF;;
    // MSB of register address
    data_write[1] = reg  & 0xFF;
    // LSB of register address
    data_write[2] = data & 0xFF;
    i2c.write(addr, data_write, 3);
}

///////////////////////////////////////////////////////////////////
// Split 16-bit register address into two bytes and write
// required register address to VL6180 and read the data back
///////////////////////////////////////////////////////////////////

char ReadByte(wchar_t reg, char addr) {
    char data_write[2];
    char data_read[1];
   
    data_write[0] = (reg >> 8) & 0xFF; // MSB of register address
    data_write[1] = reg  & 0xFF; // LSB of register address
   
    i2c.write(addr, data_write, 2);
    i2c.read(addr, data_read, 1);
    return data_read[0];
}

///////////////////////////////////////////////////////////////////
// load settings
///////////////////////////////////////////////////////////////////

int VL6180_Init(char addr) {    
    char reset;    
   
    // check to see has it be Initialised already
    reset = ReadByte(0x016, addr);    
    if (reset==1)
    {      
        ///////////////////////////////////////////////////////////////////
        // DEFAULT SETTINGS
        ///////////////////////////////////////////////////////////////////
       
        // Mandatory : private registers
        WriteByte_Uninitialized(0x0207, 0x01, addr);
        WriteByte_Uninitialized(0x0208, 0x01, addr);
        WriteByte_Uninitialized(0x0096, 0x00, addr);
        WriteByte_Uninitialized(0x0097, 0xfd, addr);
        WriteByte_Uninitialized(0x00e3, 0x01, addr);
        WriteByte_Uninitialized(0x00e4, 0x03, addr);
        WriteByte_Uninitialized(0x00e5, 0x02, addr);
        WriteByte_Uninitialized(0x00e6, 0x01, addr);
        WriteByte_Uninitialized(0x00e7, 0x03, addr);
        WriteByte_Uninitialized(0x00f5, 0x02, addr);
        WriteByte_Uninitialized(0x00d9, 0x05, addr);
        WriteByte_Uninitialized(0x00db, 0xce, addr);
        WriteByte_Uninitialized(0x00dc, 0x03, addr);
        WriteByte_Uninitialized(0x00dd, 0xf8, addr);
        WriteByte_Uninitialized(0x009f, 0x00, addr);
        WriteByte_Uninitialized(0x00a3, 0x3c, addr);
        WriteByte_Uninitialized(0x00b7, 0x00, addr);
        WriteByte_Uninitialized(0x00bb, 0x3c, addr);
        WriteByte_Uninitialized(0x00b2, 0x09, addr);
        WriteByte_Uninitialized(0x00ca, 0x09, addr);
        WriteByte_Uninitialized(0x0198, 0x01, addr);
        WriteByte_Uninitialized(0x01b0, 0x17, addr);
        WriteByte_Uninitialized(0x01ad, 0x00, addr);
        WriteByte_Uninitialized(0x00ff, 0x05, addr);
        WriteByte_Uninitialized(0x0100, 0x05, addr);
        WriteByte_Uninitialized(0x0199, 0x05, addr);
        WriteByte_Uninitialized(0x01a6, 0x1b, addr);
        WriteByte_Uninitialized(0x01ac, 0x3e, addr);
        WriteByte_Uninitialized(0x01a7, 0x1f, addr);
        WriteByte_Uninitialized(0x0030, 0x00, addr);
        WriteByte_Uninitialized(0x016, 0x00, addr); //change fresh out of set status to 0    
    }  
    else {
        return -1;  
    }  
    return 0;
}

///////////////////////////////////////////////////////////////////
// Start a range measurement in single shot mode
///////////////////////////////////////////////////////////////////

int VL6180_Start_Range(char addr) {    
    WriteByte_Uninitialized(0x018,0x03, addr);  
    return 0;
}

///////////////////////////////////////////////////////////////////
// poll for new sample ready ready
///////////////////////////////////////////////////////////////////

int VL6180_Poll_Range(char addr) {    
    char status;    
    char range_status;  
         
    // check the status    
    status = ReadByte(0x04f,addr);            
    range_status = status & 0x07;
           
    // wait for new measurement ready status    
    while (range_status !=  0x00)
    {        
        status = ReadByte(0x04f,addr);        
        range_status = status & 0x07;        
        //wait_ms(50); // (can be removed)        
    }
   
    return 0;    
}


///////////////////////////////////////////////////////////////////
// Read range result (mm)
///////////////////////////////////////////////////////////////////

int VL6180_Read_Range(char addr) {    
    int range;    
    range=ReadByte(0x062, addr);    
    return range;
}

///////////////////////////////////////////////////////////////////
// clear interrupts
///////////////////////////////////////////////////////////////////

int VL6180_Clear_Interrupts(char addr) {    
    WriteByte_Uninitialized(0x015,0x07, addr);    
    return 0;
}

///////////////////////////////////////////////////////////////////
//  Main Program loop
///////////////////////////////////////////////////////////////////
/*------------------------------------------------------------------------------
//  Main Program loop
------------------------------------------------------------------------------*/
void TOF_Handler()
{
    SHDN_Pins = 0; // 0x0 or 0b0000
    wait_ms(0.5);
 
    SHDN_Pins = 2; // 0x2 or 0b0010

    VL6180_Init(address1shift);
    WriteByte_Uninitialized(0x212, address2, address1shift);
   
    SHDN_Pins = 6; // 0x6 or 0b0110
    VL6180_Init(address1shift);
    WriteByte_Uninitialized(0x212, address3, address1shift);
   
    SHDN_Pins = 14; // 0xE or 0b1110
    VL6180_Init(address1shift);
    WriteByte_Uninitialized(0x212, address4, address1shift);
   
    SHDN_Pins = 15; // 0xF or 0b1111
    VL6180_Init(address1shift);

    while (1)
    {
        Get_TOF_Reading();    
        wait_ms(100);      
    }
}
    
void Get_TOF_Reading()
{
    int Range[4];
    
    // start range measurement
    VL6180_Start_Range(address1shift);
    // poll the VL6180 till new sample ready      
    VL6180_Poll_Range(address1shift);
    Range[0] = VL6180_Read_Range(address1shift);
    VL6180_Clear_Interrupts(address1shift);
    wait_ms(10);
    
    // read range result
    VL6180_Start_Range(address2shift);
    VL6180_Poll_Range(address2shift);
    Range[1] = VL6180_Read_Range(address2shift);
    VL6180_Clear_Interrupts(address2shift);
    wait_ms(10);
    
    VL6180_Start_Range(address3shift);
    VL6180_Poll_Range(address3shift);
    Range[2] = VL6180_Read_Range(address3shift);
    VL6180_Clear_Interrupts(address3shift);
    wait_ms(10);
    
    VL6180_Start_Range(address4shift);
    VL6180_Poll_Range(address4shift);
    Range[3] = VL6180_Read_Range(address4shift);
    VL6180_Clear_Interrupts(address4shift);        
        
#ifdef ROS_TOF
    Global_TOF_Range_Mutex.lock();
    for(int IDX = 0; IDX < 4; IDX++) {
        Global_TOF_Ranges[IDX] = Range[IDX];
    }
    if(TOF_Range_Flag == false)
    {
        TOF_Range_Flag = true;
    }
    Global_TOF_Range_Mutex.unlock();
#endif
}
