/******************************************************************************/
/* Pins                                                                */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/* ToF Sensors                                                                */
/*----------------------------------------------------------------------------*/
#define SHDN_1  D43
#define SHDN_2  D44
#define SHDN_3  D45
#define SHDN_4  D46
#define SHDN_5  D47
#define SHDN_6  D48
#define SHDN_7  D49
#define SHDN_8  D50

#define SCL     D15
#define SDA     D14

/*----------------------------------------------------------------------------*/
/* Motors                                                                     */
/*----------------------------------------------------------------------------*/
#define Motor_1_IN_1    D16 //PC_6
#define Motor_1_IN_2    D17 //PB_15
#define Motor_1_PWM     D18 //PB_13
#define Motor_1_A       D24 //PA_4
#define Motor_1_B       D19 //PB_12

#define Motor_2_IN_1    D20 //PA_15
#define Motor_2_IN_2    D21 //PC_7
#define Motor_2_PWM     D25 //PB_4
#define Motor_2_A       D22 //PB_5
#define Motor_2_B       D23 //PB_3

/*----------------------------------------------------------------------------*/
/* Power Monitor                                                              */
/*----------------------------------------------------------------------------*/
#define MON_VBATT   A6 | ADC_VBAT
#define MON_5V0     A7
#define MON_3V3     A8

/*----------------------------------------------------------------------------*/
/* UART to RPi                                                                */
/*----------------------------------------------------------------------------*/
#define SP_TX   D1
#define SP_RX   D0

/*----------------------------------------------------------------------------*/
/* Extra UART                                                                 */
/*----------------------------------------------------------------------------*/
#define UART1_RX    D52
#define UART1_TX    D53
#define UART1_RTS   D54
#define UART1_CTS   D55

/*----------------------------------------------------------------------------*/
/* SPI                                                                        */
/*----------------------------------------------------------------------------*/
#define INT1        D7
#define INT2        D6

#define INTM        D4
#define MISO        D3
#define DEN         D2

#define CS_M        D42
#define CS_AG       D41

#define DRDY        D40
#define CLK         D39
#define MOSI        D38
#define SPR_SPI_CS  D37

/*----------------------------------------------------------------------------*/
/* Other Stuff                                                                */
/*----------------------------------------------------------------------------*/
#define BUZZER      D13

#define RED         D8
#define GRN         D9
#define BLU         D10

#define LINE_OUT1   A0
#define LINE_OUT2   A1
#define LINE_OUT3   A2
#define LINE_OUT4   A3
#define LINE_OUT5   A4

/*----------------------------------------------------------------------------*/
/* Spare I/O                                                                  */
/*----------------------------------------------------------------------------*/
#define PE_4    D57
#define PE_5    D58
#define PE_6    D59
#define PE_3    D60
#define PF_8    D61
#define PF_7    D62
#define PF_9    D63

/******************************************************************************/