#include "mbed.h"
#include "Debug.hpp"
#include "Battery_Monitor.hpp"
#include "General.hpp"
#include "Pins.h"
#include "rtos.h"

//extern Mutex Global_Battery_Level_Mutex;
//extern float Global_Battery_Level;
//extern float Global_Battery_Value;

float Global_Battery_Level;
float Global_Battery_Value;
bool Battery_Update_Flag;
Mutex Global_Battery_Level_Mutex;

void Battery_Monitor::battCheck(void)
{
    float Read_V_Batt = this->V_Batt.read() * 16.67f;

    float temp_batLev = Read_V_Batt - Minimum_VBatt;
    this->Battery_Level = (Maximum_VBatt - Minimum_VBatt) / temp_batLev;

    Global_Battery_Level_Mutex.lock();
    Global_Battery_Value = Read_V_Batt;
    Global_Battery_Level = this->Battery_Level;
    if(Battery_Update_Flag == false)
    {
        Battery_Update_Flag = true;
    }
    Global_Battery_Level_Mutex.unlock();

    /*    
    Channel_1.write(this->Battery_Level);
    Channel_2.write(1.0f-(this->Battery_Level));

    char Btry_lvl_string[20];
    sprintf(Btry_lvl_string, "Battery Level is : %1.2f",Battery_Level);
    Flag_Error(warning, Btry_lvl_string);
    
    if(this->Battery_Level < 0.2f && this->Battery_Level > 0.1f)
    {  
        Flag_Error(warning, "Power Below 20% - Charging Required!\n\r");
    } else if(this->Battery_Level < 0.05f) {  
        Flag_Error(criticalFAILURE, "Power Below 5% - Power Failure Iminent!\n\r");
    }
    */
    //pc.printf("Voltage readings are: VBATT: %f\n\r", Read_V_Batt);
}
