#include "mbed.h"
//#include "General.hpp"
//#include "rtos.h"
#include "Pins.h"

#ifndef Define_ONCE_VL6180
#define Define_ONCE_VL6180

#define num_VL6180 1
#define SHDN_Pins_Cell {PC_9} //, PC_11, PD_2, PG_3}
#define TOF_Addresses {0x29} //, 0x2A, 0x2B, 0x2C}
#define Shifted_TOF_Addresses {0x82} //, 0x84, 0x86, 0x88}


//Addresses
#define address1   (0x29)
#define address2   (0x2A)
#define address3   (0x2B)
#define address4   (0x2C)

//Shifted addresses, so the R/W command can be added
#define address1shift   (address1<<1)
#define address2shift   (address2<<1)
#define address3shift   (address3<<1)
#define address4shift   (address4<<1)


// Thread that runs TOF sensors
void TOF_Handler();

int VL6180_Init(char addr);
void WriteByte_Uninitialized(wchar_t reg, char data, char addr);
char ReadByte(wchar_t reg, char addr);
int VL6180_Start_Range(char addr);
int VL6180_Poll_Range(char addr);
int VL6180_Read_Range(char addr);
int VL6180_Clear_Interrupts(char addr);
void Get_TOF_Reading(void);

#endif
