/******************************************************************************/
/*  General definitions                                                       */
/******************************************************************************/
// define all datatypes to make data sizes more understandable
#define     S_BYTE      signed char
#define     BYTE        char
#define     U_BYTE      unsigned char
#define     INT_16      short int
#define     UINT_16     unsigned short int
#define     INT_32      int
#define     UINT_32     unsigned int
#define     INT_64      long int
#define     UINT_64     unsigned long int
#define     FLOAT_32    float
#define     FLOAT_64    double
#define     FLOAT_96    long double

// define ERROR levels
#define criticalFAILURE 0 // critical FAILURE shows full system broken
#define criticalERROR   1 // critical ERROR means atleast one system failed
#define fault           2 // FAULT means atleast one system is not working properly
#define warning         3 // warning means atleast one system may be functioning incorecctly
/******************************************************************************/


/******************************************************************************/
/*  Defentions of Pins and Topics for ROS and attached peripherals            */
/******************************************************************************/
#define Control_Topic   "/Nucleo/cmd_vel"
#define TOF_Topic       "/Nucleo/TOF_Ranges"
#define Status_Topic    "/Nucleo/Status"

#define Serial_Error_Tx SERIAL_TX
#define Serial_Error_Rx SERIAL_RX

#define ROS_Tx PD_5
#define ROS_Rx PD_6
#define ROS_BaudRate 115200
/******************************************************************************/


#ifndef Define_ONCE_General
#define Define_ONCE_General

#endif