/*------------------------------------------------------------------------------
Creator : Jonathan Wheadon
Date : 29/11/2019
------------------------------------------------------------------------------*/

#include "mbed.h"
#include "rtos.h"
#include "General.hpp"
#include "Pins.h"

// Use generic to set number of rows in table
#define Rows 15
#define MaxDATA (Rows*3)

// Define 8 bit colours for printing to terminal 
#define ColourRED    9
#define ColourAMBER  166
#define ColourYELLOW 11
#define ColourGREEN  118
#define ColourBLUE   12
#define ColourWHITE  255
#define ColourPURPLE 5

#ifndef Define_ONCE_Debug
#define Define_ONCE_Debug

    // Structure used to print ERROR messages to the terminal
    typedef struct 
    {
        char ErrorCode;
        char* TimeStamp;
        char* ErrorMSGS;
    } Error;

    // Class Terminal expects tx and rx pins and is used for controlling a serialy conected terminal
    class Terminal {
        public:
            Terminal(PinName tx, PinName rx) : pc(tx, rx){}
            void init(void);                                // Initialise terminal and start all timers/interupts

            void ERROR_MSGS(Error msgs);    // function to print error msgs to debug section of terminal
            void printDEBUG(char* msgs);    // function to print msgs to debug section of terminal
   
            void Cursor(char X, char Y);            // Function moves cursor to position defined by co-ordinates x,y
            void Colour(char COLOUR);               // Function changes terminal print colour to 8 bit colour defined by COLOUR
            void PrintDATA(char* STRING, char IDX); // Prints DATA to specific cell in table specified by IDX
            
        private:
            // define serial objects and function needed to change its parameters
            Serial pc;                              // Serial object to be used for terminal
            
            // Int stores current position in the table
            int CurrentIDX;
            // COL stores current print colour
            bool col;
            
            //  Function needed to handle command inputs from terminal
            void Input_Handler(void);       // ISR handler for whenever a charecter is input to terminal
            void checkKEY(void);            // Functrion gets charecter from terminal input
            void HandleCOMMAND(void);       // Functions handles any commands input into terminal
            char buffer_pointer;            // stores current point in terminal input line
            char Terminal_buffer[30];       // Buffer to store command
    };
    
#endif

// Thread used for controlling terminal
void TerminalThread(void);

// Functions to convert between data types
float strTOflt(char ary[4]);     // converts a string to a float ( max of 1 decimal place )
int strTOint(char ary[3]);       // converts a string to an INT ( 1 to 999 only )

void Flag_Error(int ErrorCode, char* ErrorMSG);
