#include "mbed.h"
#include "General.hpp"
#include "Pins.h"
#include "rtos.h"

#define Minimum_VBatt 3.6f
#define Maximum_VBatt 4.2f
#define PWM_Freq 200.0f

#ifndef Define_ONCE_Battery_Monitoring
#define Define_ONCE_Battery_Monitoring

class Battery_Monitor
{
    public:
        Battery_Monitor(PinName Batt_PIN, int sample_Freq):  V_Batt(Batt_PIN), Sample_Freq(sample_Freq) //(PinName Batt_PIN, int sample_Freq, PinName RED_Channel, PinName GREEN_Channel, PinName BLUE_Channel): V_Batt(Batt_PIN), Sample_Freq(sample_Freq), Channel_1(RED_Channel), Channel_2(GREEN_Channel), Channel_3(BLUE_Channel)
        {       
            /*
            this->Channel_1.write(0.0f);
            this->Channel_1.period(1.0f/PWM_Freq);
            this->Channel_2.write(0.0f);
            this->Channel_2.period(1.0f/PWM_Freq);
            this->Channel_3.write(0.0f);
            this->Channel_3.period(1.0f/PWM_Freq);
            */
            
            this->BattCheck.attach(this, &Battery_Monitor::battCheck, 1/Sample_Freq);
        };
    
        float GetBatteryLevel(void)
        {
            return Battery_Level;
        }
    
    private:
        void battCheck(void);
        int Sample_Freq;
        
        float Battery_Level;
        
        Ticker BattCheck;
        AnalogIn V_Batt;
        
        /*
        PwmOut Channel_1;
        PwmOut Channel_2;
        PwmOut Channel_3;
        */
};

#endif
