/*------------------------------------------------------------------------------
Creator : Jonathan Wheadon ; Ben Gordon ; Joel Pallent
Date : 
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : "mbed.h" ; "SDReader.hpp" ; "rtos.h" ; "General.hpp" ;
"NetWorking.hpp" ; "Display.hpp" ; "Terminal.hpp" ; "Sample.hpp"
Purpose : Low power enviromental sensor using multi threading, has four outputs,
SD card, Terminal, LCD, and a website hosted on the ip "10.0.0.10". Two inputs
LDR (for light values), BMP280 (for pressure and temperature)
------------------------------------------------------------------------------*/

#include "mbed.h"
#include "SDReader.hpp"
#include "rtos.h"
#include "General.hpp"
#include "NetWorking.hpp"
#include "Display.hpp"
#include "Terminal.hpp"
#include "Sample.hpp"
#include "cyclicalBUFFER.hpp" 
#include "WatchDog.hpp"

// Threads
Thread Display_THREAD(osPriorityNormal);
Thread NetWorking_THREAD(osPriorityNormal);
Thread sample_THREAD(osPriorityRealtime);
Thread SDcard_THREAD(osPriorityNormal);
Thread Terminal_THREAD(osPriorityNormal);
Thread WatchDog_THREAD(osPriorityNormal);

// Thread ID for the Main function (CMSIS API)
osThreadId tidMain;

//int main starts all threads then becomes TerminalThread
int main(void)
{
    // Main thread ID
    tidMain = Thread::gettid();

    // Start each thread
    Display_THREAD.start(DisplayThread);
    sample_THREAD.start(SampleThread);
    SDcard_THREAD.start(SDThread);
    Terminal_THREAD.start(TerminalThread);
    
    // Create Watchdog, and start thread to kick watchdog every 200 mili seconds
    WatchDog(5, 1000);
    WatchDog_THREAD.start(WatchDogThread);
    
    // have Main become
    NetWorkingThread();

    while(1);
}

