/*------------------------------------------------------------------------------
Creator : Ben Gordon
Date : 
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : 
Purpose : 
------------------------------------------------------------------------------*/
#include "dateTime.hpp"
//Constructor
/*dateTime(PinName GREEN, PinName YELLOW, PinName RED) : _green(GREEN), _yellow(YELLOW), _red(RED) {
    setDate(); //Sets default date 01/01/1970 00:00:00
    setTime();
}*/
struct tm _addTime_struct;
struct tm _setTime_struct;

struct tm _updateTime_struct;

DigitalOut _green(PB_11);
DigitalOut _yellow(PB_10);
DigitalOut _red(PE_15);

char dateTimeStr[20];
char dateStr[11];
char timeStr[9];

////---------------------------SET DATE AND TIME----------------------------////
BYTE setTime(S_BYTE hours, S_BYTE minutes, S_BYTE seconds)
{
    //Get currently set time
    _setTime_struct = getRawTime();
    
    //Setting Time
    _setTime_struct.tm_hour = hours;
    _setTime_struct.tm_min  = minutes;
    _setTime_struct.tm_sec  = seconds;
    
    return updateSystemTime();
}

//Setting the date and time
BYTE setDate(S_BYTE days, S_BYTE months, INT_32 years)
{
    //Get currently set time
    _setTime_struct = getRawTime();
    
    //Setting Date
    _setTime_struct.tm_mday = days;
    _setTime_struct.tm_mon  = months -1;
    _setTime_struct.tm_year = years  -1900;
    
    return updateSystemTime();
}
////------------------------------------------------------------------------////
////////////////////////////////////////////////////////////////////////////////
////---------------------------ADD DATE AND TIME----------------------------////
void overFlow(INT_32 *base, INT_32 lower, INT_32 upper)
{
    if(*base < lower)
    {
        *base = upper;
    }
    else if (*base > upper)
    {
        *base = lower;
    }
}

void addDay(S_BYTE days)
{
    struct tm _newTime_struct = _addTime_struct;
    
    _newTime_struct.tm_mday = _newTime_struct.tm_mday + days;
    
    overFlow(&_newTime_struct.tm_mday,1,31);
    
    BYTE error = checkStruct(_newTime_struct);
    
    if(!(error > 1))
    {
        _addTime_struct = _newTime_struct;
    }
}

void addMonth(S_BYTE months)
{
    struct tm _newTime_struct = _addTime_struct;
    
    _newTime_struct.tm_mon = _newTime_struct.tm_mon + months;
    
    overFlow(&_newTime_struct.tm_mon,1,12);
    
    BYTE error = checkStruct(_newTime_struct);
    if(!(error > 1))
    {
        _addTime_struct = _newTime_struct;
    }
}

void addYear(INT_32 years)
{
    struct tm _newTime_struct = _addTime_struct;                //Define a structure for the new calculated
    
    _newTime_struct.tm_year = _newTime_struct.tm_year + years;  //Update new time
    
    overFlow(&_newTime_struct.tm_year,1970,2106);
    
    BYTE error = checkStruct(_newTime_struct);                 //Check for errors
    
    if(!(error > 1))                                            //If no errors are found, update the time structure
    {
        _addTime_struct = _newTime_struct;
    }
}

void addHour(S_BYTE hours)
{
    struct tm _newTime_struct = _addTime_struct;
    
    _newTime_struct.tm_hour = _newTime_struct.tm_hour + hours;
    
    overFlow(&_newTime_struct.tm_hour,0,23);
    
    BYTE error = checkStruct(_newTime_struct);
    if(!((error > 1)||(_newTime_struct.tm_hour < 0)||(_newTime_struct.tm_hour > 23)))
    {
        _addTime_struct = _newTime_struct;
    }
}

void addMin(S_BYTE minutes)
{
    struct tm _newTime_struct = _addTime_struct;
    
    _newTime_struct.tm_min = _newTime_struct.tm_min + minutes;
    
    overFlow(&_newTime_struct.tm_min,0,59);
    
    BYTE error = checkStruct(_newTime_struct);
    if(!((error > 1)||(_newTime_struct.tm_min < 0)||(_newTime_struct.tm_min > 59)))
    {
        _addTime_struct = _newTime_struct;
    }
}

void addSec(S_BYTE seconds)
{
    struct tm _newTime_struct = _addTime_struct;
    
    _newTime_struct.tm_sec = _newTime_struct.tm_sec + seconds;
    
    overFlow(&_newTime_struct.tm_sec,0,59);
    
    BYTE error = checkStruct(_newTime_struct);
    if(!((error > 1)||(_newTime_struct.tm_sec < 0)||(_newTime_struct.tm_sec > 59)))
    {
        _addTime_struct = _newTime_struct;
    }
}

BYTE checkStruct(struct tm check)
{
   //Initialise LEDs [for debugging] 
    _green  = 0;
    _yellow = 0;
    _red    = 0;
    
    //Check new set time is within range of valid dates (1970 - 2106)
    if((check.tm_year < 1970-1900)||(check.tm_year > 2106-1900))
    {
        _red = 1;
        return 2; //ERROR_2 Year outside of valid range [1970 - 2106]
    }
    
    //Update structure with correct dates (e.g. 32/10 would become 1/11)
    struct tm _newTime_struct = check;
    time_t _newTime_time = mktime(&_newTime_struct);
    _newTime_struct = *localtime(&_newTime_time);
    
    //Check structure has remained same (if not, invalid input has been entered (eg 32nd day or 61s minute)
    if((check.tm_year != _newTime_struct.tm_year)||
       (check.tm_mon  != _newTime_struct.tm_mon )||
       (check.tm_mday != _newTime_struct.tm_mday)||
       (check.tm_hour != _newTime_struct.tm_hour)||
       (check.tm_min  != _newTime_struct.tm_min )||
       (check.tm_sec  != _newTime_struct.tm_sec ))
    {   
        _yellow = 1;
        printf("YEAR IS %d", _newTime_struct.tm_year);
        if(_newTime_struct.tm_year < (1970-1900))
        {
            _red = 1;
            return 3; //ERROR_03 Date exceeds maximum range [06/02/2106 06:28:14]
        }
        
        return 1; //ERROR_01 Index exceeds max value [e.g Date = 32/31 or Hour = 26/24]
    }
    _green = 1;
    return 0; //ERROR_00 No errors
}
////------------------------------------------------------------------------////
////////////////////////////////////////////////////////////////////////////////

BYTE updateSystemTime()
{
    //Checking DateTime remains in valid format
    BYTE error = checkStruct(_setTime_struct);
    
    //If no errors are returned, then set the DateTime to set values.
    if(!error){
        set_time(mktime(&_setTime_struct));
    }
    
    //Return error to be used for terminal display
    return error;
}

BYTE confirmDate()
{
    BYTE error;
    error = checkStruct(_addTime_struct);
    
    if(!error)
    {
        mktime(&_addTime_struct);
        updateSystemTime();
    }
    else
    {
        while(error)
        {
            _addTime_struct.tm_mday = _addTime_struct.tm_mday - 1;
            error = checkStruct(_addTime_struct);
        }
        mktime(&_addTime_struct);
        return 1;
    }
    return 0;
}

char* getSetDate()
{
    return printDate(_addTime_struct);
}

char* getSetTime()
{
    return printTime(_addTime_struct);
}

char* startEditDate()
{
    _addTime_struct = getRawTime();
    return getSetDate();
}

char* startEditTime()
{
    _addTime_struct = getRawTime();
    return getSetTime();
}

void   endEdit()
{
    set_time(mktime(&_addTime_struct));
}

char* getSystemDateTime()
{
    struct tm _current_time = getRawTime();
    sprintf(dateTimeStr,"%s %s",printDate(_current_time),printTime(_current_time));
    return dateTimeStr;
}

////------------------------------------------------------------------------////


struct tm getRawTime()
{
    time_t rawTime;
    time(&rawTime);
    return *localtime(&rawTime);
}

//time_t range 0 - 0xFFFFFFFFFFFE [01/01/1970 00:00:00 - 06/02/2106 06:28:14]

char* printDate(struct tm _time_struct) 
{
    sprintf(dateStr,"%02d/%02d/%4d",
                    getDay(_time_struct),
                    getMonth(_time_struct),
                    getYear(_time_struct));
    return dateStr;
}

char* printTime(struct tm _time_struct)
{
    sprintf(timeStr,"%02d:%02d:%02d",
                    getHour(_time_struct),
                    getMin(_time_struct),
                    getSec(_time_struct));
    return timeStr;
}

signed INT_32 getYear(struct tm _time_struct)  {return _time_struct.tm_year + 1900;}
BYTE          getMonth(struct tm _time_struct) {return _time_struct.tm_mon + 1;    }
BYTE          getDay(struct tm _time_struct)   {return _time_struct.tm_mday;       }
BYTE          getHour(struct tm _time_struct)  {return _time_struct.tm_hour;       }
BYTE          getMin(struct tm _time_struct)   {return _time_struct.tm_min;        }
BYTE          getSec(struct tm _time_struct)   {return _time_struct.tm_sec;        }

