/*------------------------------------------------------------------------------
Creator : Joel Pallent ; Jonathan Wheadon
Date : 18/12/2018
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : "General.hpp" and "mbed.h"
Purpose : This is the header file defining the class for our cyclical_Buffer
------------------------------------------------------------------------------*/

#include "mbed.h"
#include "General.hpp"

#ifndef __cyclicalBUFFER__
#define __cyclicalBUFFER__

class cyclical_Buffer {
    public:
        cyclical_Buffer(UINT_32 size) : BUFFERSIZE(size), buffer(new mail_t[size]), spaceAvailable(size), samplesInBuffer(0) {newestIndex = size-1; oldestIndex = size-1; NoOfStoredSamples = 0; BufferFull = false;}

        // Functions for cyclical buffer using semaphores (producer consumer patern)
        void addDataToBuffer(mail_t Data);
        mail_t takeDataFromBuffer(void);
        
        // Functions for keep most resant samples overiding oldest
        void addDataToBufferOverride(mail_t Data);  // Function will add data to buffer, if buffer is full it overides the oldest data
        mail_t ReadNfromBuffer(UINT_32 N);          // Function will read the data stored which is Nth from oldest sample. N = 0 is oldest, N = Buffersize = newest
            
    private:            
        //Output buffer
        const UINT_32 BUFFERSIZE;
        mail_t* buffer;
        UINT_32 newestIndex; //First time it is incremented, it will be 0
        UINT_32 oldestIndex;
        UINT_32 NoOfStoredSamples;
        bool BufferFull;

        //Thread sychronisation primatives
        Semaphore spaceAvailable;
        Semaphore samplesInBuffer;
        Mutex bufferLock;
};

#endif
