/*------------------------------------------------------------------------------
Creator : Joel Pallent ; Jonathan Wheadon
Date : 06/12/2018
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : "semaphore.hpp"
Purpose : to control the flow of data to synchronise everything so that there is
no problems with the transmit and retrival of data between threads

------------------------------------------------------------------------------*/

#include "cyclicalBUFFER.hpp" 

//Producer
void cyclical_Buffer::addDataToBuffer(mail_t Data)     
{
    //Is there space?
    int32_t Nspaces = spaceAvailable.wait();
             
    //Ok, there is space - take the lock
    bufferLock.lock();
        
    //Update buffer
    newestIndex = (newestIndex+1) % BUFFERSIZE;  
    buffer[newestIndex] = Data;               
    //printf("Data added to buffer"); 
    
    //Release lock
    bufferLock.unlock();
    
    //Signal that a sample has been added
    samplesInBuffer.release();
    NoOfStoredSamples += 1;
    
    if(NoOfStoredSamples == BUFFERSIZE){
        BufferFull = true;
    } else {
        BufferFull = false;
    }
}

// the function addDataToBufferOverride adds data to the buffer, if the buffer is full it overides the oldest stored data
void cyclical_Buffer::addDataToBufferOverride(mail_t Data)     
{
    bufferLock.lock();
    
    if( BufferFull == true ){
        oldestIndex = (oldestIndex+1) % BUFFERSIZE;
        Data = buffer[oldestIndex];
        NoOfStoredSamples -= 1;
        BufferFull = false;
    }
        
    //Update buffer
    newestIndex = (newestIndex+1) % BUFFERSIZE;  
    buffer[newestIndex] = Data;               
    //printf("Data added to buffer"); 
    
    //Release lock
    bufferLock.unlock();
    
    //Signal that a sample has been added
    NoOfStoredSamples += 1;
    
    if(NoOfStoredSamples == BUFFERSIZE){
        BufferFull = true;
    } else {
        BufferFull = false;
    }
}

//Consumer
mail_t cyclical_Buffer::takeDataFromBuffer(void)
{    
    //Are thre any samples in the buffer
    int32_t Nsamples = samplesInBuffer.wait();
        
    //Ok, there are samples - take the lock
    bufferLock.lock();   
    
    mail_t Data;
    
    //Update buffer - remove oldest
    oldestIndex = (oldestIndex+1) % BUFFERSIZE;
    Data = buffer[oldestIndex];    
    
    //Release lock
    bufferLock.unlock();
    
    //Signal there is space in the buffer
    spaceAvailable.release();                            // change the space available soother things rying to acces the buffer can see there is space
    NoOfStoredSamples -= 1;
    
    BufferFull = false;
       
    //return a copy of the result
    return Data;                                     // returing the input data out in new structure.
}

// Returns data stored in the Nth place of the buffer
mail_t cyclical_Buffer::ReadNfromBuffer(UINT_32 N)
{
    bufferLock.lock();
    
    // If N exceeds the stored samples
    if((NoOfStoredSamples == 0) || (N > (NoOfStoredSamples - 1))){
        
        mail_t voided = {NULL,NULL,NULL,NULL};
        
        bufferLock.unlock();

        return voided;
        
    } else {
        
        UINT_32 idx = (newestIndex - N + 1) % BUFFERSIZE;   
        
        mail_t Data;
        
        Data = buffer[idx];    
        
        //Release lock
        bufferLock.unlock();
            
        //return a copy of the result
        return Data;
    }
}

