#include "WatchDog.hpp"
#include "mbed.h"

/* Enables Watchdog Timer -> T(period, s)= (1/32kHz)(4)(2^(IWDG_PR[2:0]))(IWDG_RLR[11:0]+1))*/
void WatchDog (int prescaler, int reload) 
{ 				
	IWDG->KR 	|= 0x0000CCCC; 	// enable IWDG (watchdog)
	IWDG->KR 	|= 0x00005555; 	// enable register access to PR & RLR
	IWDG->PR 	|= prescaler; 	// Set prescaler 
	IWDG->RLR 	|= reload;		// set Reload 				
}

/* Reset WatchDog timer */
void Kick (void) 
{ 
	//Reset Watchdog counter
	IWDG->KR |= 0x0000AAAA;
}

void WatchDogThread(void)
{	
	while(1)
	{
		Kick();
		Thread::wait(200);	
	}	
}

