/*******************************************************************************
This header defines Terminal class which has all the functions for controlling a 
terminal, the serial object is kept private and therefore can only be accessed
through function of the terminal class.
*******************************************************************************/

#include "mbed.h"
#include "rtos.h"
#include "General.hpp"
#include "Display.hpp"
#include "dateTime.hpp"
#include "cyclicalBUFFER.hpp"

// Use generic to set number of rows in table
#define Rows 15
#define MaxDATA (Rows*4)

// Define 8 bit colours for printing to terminal 
#define ColourRED    9
#define ColourAMBER  166
#define ColourGREEN  118
#define ColourBLUE   12
#define ColourWHITE  255
#define ColourPURPLE 5

#ifndef Define_ONCE_Terminal
#define Define_ONCE_Terminal

    typedef struct 
    {
        BYTE ErrorCode;
        BYTE* ErrorMSGS;
    } Error;

    // Class Terminal expects tx and rx pins and is used for controlling a serialy conected terminal
    class Terminal {
        public:
            Terminal(PinName tx, PinName rx) : pc(tx, rx){Logging_STATE = true;}
            void init(void);                                // Initialise terminal and start all timers/interupts
            void updateSDstate(bool SDstate);               // Updates displayed SD state
            void updateNetWorkstate(bool NetWorkstate);     // Updates displayed NetWork state
            void addDATA(void);                             // Function called by sample thread to add new data to terminal
            
            void ERROR_MSGS(Error msgs);   // function to print error msgs to debug section of terminal
            
            bool getLoggingState(void) {return Logging_STATE;} // return the priavte variable Logging_STATE
            
        private:
            // define serial objects and function needed to change its parameters
            Serial pc;                              // Serial object to be used for terminal
            BYTE currentIDX;                        // Stores current cell in terminal
            void Cursor(BYTE X, BYTE Y);            // Function moves cursor to position defined by co-ordinates x,y
            void Colour(BYTE COLOUR);               // Function changes terminal print colour to 8 bit colour defined by COLOUR
            void PrintDATA(BYTE* STRING, BYTE IDX); // Prints DATA to specific cell in table specified by IDX
            bool col;                               // define current colour for samples to be printed in
            void printDEBUG(BYTE* msgs);
            void printBufferedData(mail_t bufferedDATA);
            
            // Functions needed to display time in top right of terminal
            Ticker Terminal_ticker;         // Ticker calls "Ticker_Handler" every second
            void Ticker_Handler(void);      // ISR hanler fires every second to add "updateTIME" to terminal event queue
            void updateTIME(void);          // Prints current time to top right of terminal

            //  Function needed to handle command inputs from terminal
            void Input_Handler(void);       // ISR handler for whenever a charecter is input to terminal
            void checkKEY(void);            // Functrion gets charecter from terminal input
            void HandleCOMMAND(void);       // Functions handles any commands input into terminal
            BYTE buffer_pointer;            // stores current point in terminal input line
            BYTE Terminal_buffer[30];       // Buffer to store command
            bool Logging_STATE;              // Stores whether Logging has been enabled/disabled
    };
    
#endif

// Thread used for controlling terminal
void TerminalThread(void);

FLOAT_32 strTOflt(BYTE ary[4]);
INT_32 strTOint(BYTE ary[3]);
BYTE handleTIME(BYTE ary[8]);
BYTE handleDATE(BYTE ary[10]);


