/*------------------------------------------------------------------------------
Creator : Joel Pallent
Date : 06/12/2018
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : "Samples.hpp" 
Purpose : The purpose of this file is to collect data from the peripherals,
convert it into an appropriate form then put it into a mailbox so other parts
access the data
Return data: This file returns sample data in NetWork_Data and Terminal_mail

------------------------------------------------------------------------------*/
#include "SDReader.hpp"
#include "Sample.hpp"

Ticker t;                               // set ticker to control sample rate
BME280 sensor(I2C_SDA, I2C_SCL);        // temp and pressure sensor setup
AnalogIn LDR_ADC_In(A0);                // input for LDR
FLOAT_32 fLDR = 0.0f;                   // initializeing the data to zero
FLOAT_32 voltage = 0.0f;                // initializeing the data to zero

// Set starting sample rate
FLOAT_32 SampleRate = 15.0f;

// Needed to print messgaes to terminal
extern EventQueue TerminalQueue;
extern Terminal PC;

extern EventQueue SDQueue;
extern SDReader SD; 

extern EventQueue DisplayQueue;
extern Display display;

extern Mutex NetWork_DATA_mutex;
extern mail_t NetWork_DATA;

// Timeout to debug on the sample frequency and detect if sample jitter has occured
Timeout SampleFrequencyDebugger;
void SampleFrequencyDebuggerHandler(void);

Mail<mail_t, 32>Terminal_mail;          // setting up mailbox for Terminal
Mail<mail_t, 32>Display_mail;   
Mail<mail_t, 32>SDreader_mail;  

EventQueue SampleQueue(2 * EVENTS_EVENT_SIZE);

// Create a cyclical buffer with 120 spaces as per coursework requirement 2
cyclical_Buffer internalBuffer(120);

// takes sample then peroidically takes sample every 15s using ticker
void SampleThread(void)
{
    start_sampling(true);
    
     while(true)
     {
        SampleQueue.dispatch_forever();  
     }  
}

// this function converts converts the data into strings then pushes them into respective mailbox or data path 
void take_sample(void)
{
    //convert to strings
    BYTE temperature [8];
    BYTE pressure [8];
    BYTE light [8]; 
    BYTE SampleTimeTag [20];   
    
    fLDR = LDR_ADC_In;          // read adc data from LDR
    voltage = fLDR* 3.3f;       // convert adc data to voltage
            
    FLOAT_32 Temp = sensor.getTemperature();
    FLOAT_32 Press = sensor.getPressure();
    strcpy(SampleTimeTag, getSystemDateTime());
    
    sprintf(temperature, "%2.2f", Temp);    // convert temperature float to string
    sprintf(pressure, "%4.2f", Press);      // convert pressure float to string
    sprintf(light, "%1.2f", voltage);       // convert LDR voltage to string   
    
    if(PC.getLoggingState() == true){
        mail_t *TerminalMail = Terminal_mail.alloc();   // telling what mailbox to send data to
        strcpy(TerminalMail->MTEMP, temperature);       // set temperature 
        strcpy(TerminalMail->MPRESS, pressure);         // set pressure 
        strcpy(TerminalMail->MLIGHT, light);            // set light as voltage
        strcpy(TerminalMail->MDate, SampleTimeTag);     // Get and set system time from display thread
        Terminal_mail.put(TerminalMail);                // send samples to terminal mailbox
        TerminalQueue.call(&PC, &Terminal::addDATA);
    }
    
    if(SD.getSDstate() == true){
        mail_t *SDreaderMail = SDreader_mail.alloc();   // telling what mailbox to send data to
        strcpy(SDreaderMail->MTEMP, temperature);       // set temperature 
        strcpy(SDreaderMail->MPRESS, pressure);         // set pressure 
        strcpy(SDreaderMail->MLIGHT, light);            // set light as voltage
        strcpy(SDreaderMail->MDate, SampleTimeTag);     // Get and set system time from display thread
        SDreader_mail.put(SDreaderMail);                // send samples to SD reader mailbox
        SDQueue.call(&SD, &SDReader::addDATA);
    }
    
    mail_t *DisplayMail = Display_mail.alloc();     // telling what mailbox to send data to
    strcpy(DisplayMail->MTEMP, temperature);        // set temperature 
    strcpy(DisplayMail->MPRESS, pressure);          // set pressure 
    strcpy(DisplayMail->MLIGHT, light);             // set light as voltage
    strcpy(DisplayMail->MDate, SampleTimeTag);      // Get and set system time from display thread
    Display_mail.put(DisplayMail);                  // send samples to terminal mailbox
    DisplayQueue.call(&display, &Display::addData);

   
   // set network data
    NetWork_DATA_mutex.lock();
    strcpy(NetWork_DATA.MTEMP, temperature);    // set temperature 
    strcpy(NetWork_DATA.MPRESS, pressure);      // set pressure 
    strcpy(NetWork_DATA.MLIGHT, light);         // set light
    strcpy(NetWork_DATA.MDate, SampleTimeTag);  // Get and set system time from display thread
    NetWork_DATA_mutex.unlock();
    
    // Create mail_t Data to store in internal memory
    mail_t BufferData;     
    strcpy(BufferData.MTEMP, temperature);     // set temperature 
    strcpy(BufferData.MPRESS, pressure);       // set pressure 
    strcpy(BufferData.MLIGHT, light);          // set light as voltage
    strcpy(BufferData.MDate, SampleTimeTag);   // Get and set system time from display thread
    
    internalBuffer.addDataToBufferOverride(BufferData); // add data to cyclical buffer which overides oldest sample
    
    SampleFrequencyDebugger.detach();
}

// This function is called by the ticker and adds the take_sample function to the event queue
void sample_handler(void)
{
    SampleQueue.call(take_sample);                        // once sample is ready to be collected call function to get data
    SampleFrequencyDebugger.attach(&SampleFrequencyDebuggerHandler, (SampleRate-0.1*SampleRate));
}

void SampleFrequencyDebuggerHandler(void)
{
    Error msgs;
    msgs.ErrorCode = fault;
    msgs.ErrorMSGS = "Sample frequency has been compromised";
    TerminalQueue.call(&PC, &Terminal::ERROR_MSGS, msgs);
}

void start_sampling(bool start)
{
    if(start == true){
        t.attach(&sample_handler,SampleRate); // attach sample handler to ticker with rate SampleRate
    } else {
        t.detach();
    }   
}

void update_sampleRATE(FLOAT_32 New_sampleRATE)
{
    SampleRate = New_sampleRATE;
    
    // update sample rate
    t.detach();
    t.attach(&sample_handler,SampleRate);
}
