/*------------------------------------------------------------------------------
Creator : 
Date : 
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : 
Purpose : 
------------------------------------------------------------------------------*/

#ifndef Define_ONCE_SDReader
#define Define_ONCE_SDReader

#include "mbed.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "General.hpp"
#include "rtos.h"

#define EDGE_FALLEN 0
#define EDGE_RISEN  1

// Class SDReader expects mosi miso sclk and cs pins and is used for controlling a spi connected sd reader
class SDReader {
    public:
        SDReader(PinName mosi, PinName miso, PinName sclk, PinName cs) : sd(mosi, miso, sclk, cs), fs("sd", &sd){}
        bool INIT(void);
        
        void addDATA(void);
        
        bool getSDstate(void) {return SDmounted;}
        
    private:
        SDBlockDevice sd;
        FATFileSystem fs;
        
        void unmount(void);
        
        void upload(BYTE DATETIME[20], BYTE LIGHT[8], BYTE TEMP[8], BYTE PRESS[8]);

        bool SDmounted;

        // Functions for buttons
        void update_SD_state(void);
        void onBoardSwitchRisingEdge();
        void onBoardSwitchFallingEdge();
        void onBoardSwitchTimeOutHandler();
};

void SDThread(void); // Thread for terminal to run in 

#endif

