/*------------------------------------------------------------------------------
Creator : Jonathan Wheadon
Date : 29/11/2018
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : "General.hpp" ; "NetWorking.hpp"
Purpose : To allow the low power enviromental sensor to publish data to a html
webpage via the onboard ethernet conection of the stm429ZI
------------------------------------------------------------------------------*/

#include "NetWorking.hpp"
#include "Terminal.hpp"

Mutex NetWork_DATA_mutex;
mail_t NetWork_DATA;

Timeout NetworkCheck;
void NetworkTimeOUT(void);
    
// Needed to print messages to terminal
extern EventQueue TerminalQueue;
extern Terminal PC;

// Thread handels networking and updates a conected PC whenever the webpage is refreshed
void NetWorkingThread(void)
{    
    // Configure an ethernet connection
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
    
    // Now setup a web server
    TCPServer srv;           // TCP/IP Server
    TCPSocket clt_sock;      // Socket for communication
    SocketAddress clt_addr;  // Address of incoming connection
    
    while (true) {
        // Open the server on ethernet stack
        srv.open(&eth);
        
        // Bind the HTTP port (TCP 80) to the server
        srv.bind(eth.get_ip_address(), 80);
        
        // Set maximum simultanious conections
        srv.listen(5);
        
        // Block and wait on an incoming connection (if page is accessed)
        srv.accept(&clt_sock, &clt_addr);
        TerminalQueue.call(&PC, &Terminal::updateNetWorkstate, true);
        NetworkCheck.detach();
        NetworkCheck.attach(&NetworkTimeOUT, 7.0f);
        
        // Get most up to date enviromental values
        float LIGHT = 0.0f;
        float TEMP = 0.0f;
        float PRES = 0.0f;
        
        // Convert to a C String
        char Light_str[8];
        char Temp_str[8];
        char Pres_str[8];
        sprintf(Light_str, "%5.3f", LIGHT );
        sprintf(Temp_str, "%5.3f", TEMP );
        sprintf(Pres_str, "%5.3f", PRES );
        
        string response;

        NetWork_DATA_mutex.lock();

        //Build the C++ string response
        response = HTTP_OPEN;
        response += NetWork_DATA.MDate;
        response += NextColumb;        
        response += NetWork_DATA.MLIGHT;
        response += NextColumb;
        response += NetWork_DATA.MPRESS;
        response += NextColumb;
        response += NetWork_DATA.MTEMP;
        response += HTTP_CLOSE;
        
        NetWork_DATA_mutex.unlock();
        
        // Send static HTML response (as a C string)
        int debug = clt_sock.send(response.c_str(), strlen(response.c_str()));
        
        wait(1);
        
        clt_sock.close();     
    }
}

void NetworkTimeOUT(void)
{
    NetworkCheck.detach();
    TerminalQueue.call(&PC, &Terminal::updateNetWorkstate, false);
}

