/*------------------------------------------------------------------------------
Creator : 
Date : 
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : 
Purpose : 
------------------------------------------------------------------------------*/
#ifndef _LCD_HPP
#define _LCD_HPP
    
    #include "mbed.h"
    #include "General.hpp"
    
    #define CLEAR   0x01
    #define RETURN  0x02
    
    #define ENTRYMODE 0x04
    #define I 0x02
    #define shift 0x01    
    
    #define DISPLAY 0x08
    #define on 0x04
    #define cursor  0x02
    #define blink   0x01    
    
    #define FUNC 0x20
    #define bit8  0x10
    #define lines2 0x08
    #define dots11 0x04
    
    #define control 0
    #define text 1
    
    #define write 0
    #define read 1
    
    #define LINE1 0x00
    #define LINE2 0x40
    
    class LCD{
        public:
            LCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) : _LCD_RS(rs), _LCD_E(e), LCD_DDRAM(d4,d5,d6,d7) {} 
            void INIT();
            void clear();
            void display(BYTE* str, UINT_16 location=NULL);
            void putt(U_BYTE c);
            void pos(UINT_16 location);
            
            void enableCursor();
            void disableCursor();
        private:
            DigitalOut _LCD_RS;
            DigitalOut _LCD_E;
            BusOut LCD_DDRAM;   
        private:
            void cmdLCD(U_BYTE cmd);
            void LCD_strobe(void);
            void set_LCD_data(U_BYTE d);
            UINT_32 findSpace(U_BYTE* str);
    };
#endif

