/*------------------------------------------------------------------------------
Creator : Jonathan Wheadon ; Ben Gordon ; Joel Pallent
Date : 06/12/2018
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : "mbed.h"
Purpose : This file is for declarations and structures that are needed for 
multiple files (makes everything neater)
------------------------------------------------------------------------------*/
#include "mbed.h"

// set to 15.0f for coursework
//#define SampleRate 5.0f

// Define Needed values for SD reader
#define Signal_UnMount 1

// define all datatypes to make data sizes more understandable
#define     S_BYTE      signed char
#define     BYTE        char
#define     U_BYTE      unsigned char
#define     INT_16      short int
#define     UINT_16     unsigned short int
#define     INT_32      int
#define     UINT_32     unsigned int
#define     INT_64      long int
#define     UINT_64     unsigned long int
#define     FLOAT_32    float
#define     FLOAT_64    double
#define     FLOAT_96    long double

// define ERROR levels
#define criticalFAILURE 0 // critical FAILURE shows full system broken
#define criticalERROR   1 // critical ERROR means atleast one system failed
#define fault           2 // FAULT means atleast one system is not working properly
#define warning         3 // warning means atleast one system may be functioning incorecctly

#ifndef Define_ONCE
#define Define_ONCE

// structure used for holding sample data in the form of strings
    typedef struct{
        BYTE MTEMP [8];
        BYTE MPRESS [8];
        BYTE MLIGHT [8];
        BYTE MDate [20];
    }mail_t;
    
#endif

// Threads
extern Thread SDcard_THREAD, Terminal_THREAD, NetWorking_THREAD;


