/*------------------------------------------------------------------------------
Creator : 
Date : 
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : 
Purpose : 
------------------------------------------------------------------------------*/
#ifndef _DISPLAY_HPP
#define _DISPLAY_HPP
    #include "mbed.h"
    #include "General.hpp"
    
    #include "dateTime.hpp"
    #include "LCD.hpp"
    
    //#include "Terminal.hpp"
    
    #define b1 PE_12
    #define b2 PE_14
    
    #define RS  PD_15   //D9
    #define E   PF_12   //D8
    #define d4  PF_13   //D7
    #define d5  PE_9    //D6
    #define d6  PF_14   //D4
    #define d7  PF_15   //D2
    
    
    #define PRESSED 1
    
void setValue(BYTE cycle,signed INT_32 value);
void waitForInput();
void DisplayThread();
void pageSelect(U_BYTE buttonValue);
void buttonActionOne(U_BYTE buttonValue);
void buttonActionTwo(U_BYTE buttonValue);
void buttonActionFour(U_BYTE buttonValue);

void buttonISR1();
void buttonISR2();

void buttonTO();
    
    class Display{
        public:
            Display(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) : _lcd(rs,e,d4,d5,d6,d7) {} 
            void INIT();
            
            void pageOne();
            void updatePageOne();
            
            void pageTwoA();
            void pageTwoB();
            
            void pageFour();
            
            void cursorPos(UINT_16 location);
            void addData();
            
            U_BYTE currentPage();
            
            void setDate(char* date);
            void setTime(char* time);
        private:
            mail_t *Data;
            LCD _lcd;
            U_BYTE pageNumber;
    };
#endif

