/*------------------------------------------------------------------------------
Creator : Ben Gordon
Date : 30/12/2018
Module : ELEC351
Project : ELEC351_GroupA
Dependencies : 
Purpose : The purpose of this thread is to manage control of button inputs and
page selection (or changing the dateTime). It also updates the main lcd screen
with data at regular 5 second intervals.
------------------------------------------------------------------------------*/
#include "Display.hpp"
//---Button Management---//
//Interrupts
InterruptIn button1(b1);
InterruptIn button2(b2);

//Dual button press management
Timeout doublePress;

//Button input store (Used to detect dual button press)
U_BYTE buttonPressed;
///////////////////////////

//extern Terminal PC;

//---Used for "setting DateTime" page---//
//Controll inputs for: {day,month,year,hour,minute,second}.
//Each having +1 and +10 (year also has +100 and +1000)
signed INT_32 increment[] = {10,1,10,1,1000,100,10,1,10,1,10,1,10,1};
//Manage cursor position
signed INT_32 cursorPosition[] = {3,4,6,7,9,10,11,12,4,5,7,8,10,11};

//---Initialise Display---//
Display display(RS,E,d4,d5,d6,d7); //rs,e,d4,d5,d6,d7

//---Set cursor position---//
U_BYTE cursorPos=0;

//---Creeate event and mail queues---//
EventQueue DisplayQueue;
extern Mail<mail_t, 32>Display_mail;

////------------------------------Main Thread-------------------------------////
void DisplayThread()
{
    //Initialise displays
    display.INIT();
    //Initialise twice to combat unknown initialisation error
    display.pageOne();
    display.pageOne();
    
    //Initialise variables
    buttonPressed = 0;
    
    //Initialise interrupts
    button1.rise(buttonISR1);
    button2.rise(buttonISR2);
    
    //Preset date time to default of 27/02/2020 01:12:45 
    
    //setDate(27,02,2020);    //27th February 2020
    //setTime(01,12,45);      //1:12:45 am
    
    while(1)
    {
        DisplayQueue.dispatch_forever();
    }
}
////////////////////////////////////////////////////////////////////////////////

////---------------------------Button Management----------------------------////
void buttonISR1()
{
    buttonPressed |= 1;
    
    if(buttonPressed != 3)
    {
        doublePress.attach(&buttonTO, 0.2);
    }
}

void buttonISR2()
{
    buttonPressed |= 2;
    
    if(buttonPressed != 3)
    {
        doublePress.attach(&buttonTO, 0.2);
    }
}

void buttonTO()
{
    if(buttonPressed != 0)
    {
        DisplayQueue.call(&pageSelect,buttonPressed);
        buttonPressed = 0;
    }
}
////////////////////////////////////////////////////////////////////////////////

void pageSelect(U_BYTE buttonValue)
{
    switch (display.currentPage())
    {
        case 1:
            buttonActionOne(buttonValue);
            break;
        case 2:
            buttonActionTwo(buttonValue);
            break;
        case 3:
            buttonActionFour(buttonValue);
            break;
    }
}

void buttonActionOne(U_BYTE buttonValue)
{
    switch(buttonValue)
    {
        case 0x01:
            display.pageTwoA();
            display.setDate(startEditDate());
            cursorPos=0;
            display.cursorPos(LINE1+cursorPosition[cursorPos]);
            break;
        
        case 0x02:
            display.pageTwoB();
            display.setTime(startEditTime());
            cursorPos=8;
            display.cursorPos(LINE1+cursorPosition[cursorPos]);
            break;
            
        case 0x03:
            display.pageFour();
            break;
    }
}
void buttonActionTwo(U_BYTE buttonValue)
{
    switch (buttonValue)
    {
        case 0x01:
            setValue(cursorPos,increment[cursorPos]);
            break;
        case 0x02:
            setValue(cursorPos,0-increment[cursorPos]);
            break;
        case 0x03:
            cursorPos++;
            if((cursorPos == 8) || (cursorPos == 12)) //8 finished date set, 12 finishes time set
            {
                endEdit();
                display.pageOne();
            }
            break;
    }
    display.cursorPos(LINE1+cursorPosition[cursorPos]);
}

void buttonActionFour(U_BYTE buttonValue)
{
    switch(buttonValue)
    {
        case 0x01:
            display.pageOne();
            break;
        
        case 0x02:
            //No Function
            break;
            
        case 0x03:
            //No Function
            break;
    }
}
void setValue(BYTE cycle,signed INT_32 value)
{
    switch(cycle)
    {
        case 0:
        case 1:
            addDay(value);
            display.setDate(getSetDate());
            break;
        
        case 2:
        case 3:
            addMonth(value);
            display.setDate(getSetDate());
            break;
            
        case 4:
        case 5:
        case 6:
        case 7:
            addYear(value);
            display.setDate(getSetDate());
            break;
            
        case 8:
        case 9:
            addHour(value);
            display.setTime(getSetTime());
            break;
        
        case 10:
        case 11:
            addMin(value);
            display.setTime(getSetTime());
            break;
        
        case 12:
        case 13:   
            addSec(value);
            display.setTime(getSetTime());
            break;
    }
}

/*============================================================================*/

////-----------------------------Display Class------------------------------////
extern Mail<mail_t, 32>Display_mail;

void Display::INIT()
{
    _lcd.INIT();
}

void Display::pageOne()
{
    _lcd.clear();
   // _lcd.disableCursor();
    
    //Temperature Page
    _lcd.display("T:",LINE1);
    _lcd.display(Data->MTEMP);
    _lcd.putt(223);
    _lcd.display("C");
    
    //LightLevel Page
    _lcd.display("L:",LINE1+9);
    _lcd.display(Data->MLIGHT);

    //Pressure Page
    _lcd.display("P:",LINE2+2);
    _lcd.display(Data->MPRESS);
    _lcd.display(" mbar");
    
    pageNumber = 1;
}

void Display::updatePageOne()
{
    _lcd.display(Data->MTEMP,LINE1+2);
    _lcd.putt(223);
    _lcd.display("C");
    
    //LightLevel Page
    _lcd.display(Data->MLIGHT,LINE1+11);

    //Pressure Page
    _lcd.display(Data->MPRESS,LINE2+4);
    _lcd.display(" mbar");
}

void Display::pageTwoA()
{
    _lcd.clear();
  //  _lcd.enableCursor();
    
    _lcd.display("00/00/0000",LINE1+3);
    _lcd.display("dd/mm/yyyy",LINE2+3);
    
    _lcd.pos(LINE1+3);
    
    pageNumber = 2;
    _lcd.enableCursor();
}

void Display::pageTwoB()
{
        _lcd.clear();
  //  _lcd.enableCursor();
    
    _lcd.display("00:00:00",LINE1+4);
    _lcd.display("hh:mm:ss",LINE2+4);
    
    _lcd.pos(LINE1+4);
    
    pageNumber = 2;
    _lcd.enableCursor();
}

void Display::pageFour()
{
    _lcd.clear();
  //  _lcd.enableCursor();
    
    _lcd.display("Life? don't talk",LINE1);
    _lcd.display("to me about life",LINE2);
    
    _lcd.pos(LINE1);
    
    pageNumber = 3;
}

void Display::addData()
{
    //Receive mail on mail queue
    osEvent evt = Display_mail.get();
    
    //Check that there is mail in queue
    if (evt.status == osEventMail) {
        Data = (mail_t*)evt.value.p;
        
        if(pageNumber == 1)
        {
            updatePageOne();
        }
        Display_mail.free(Data);
    }
}

U_BYTE Display::currentPage()
{
    return pageNumber;
}

void Display::setDate(char* date)
{
    _lcd.pos(LINE1+3);
    _lcd.display(date,LINE1+3);
}

void Display::setTime(char* time)
{
    _lcd.pos(LINE1+4);
    _lcd.display(time,LINE1+4);   
}

void Display::cursorPos(UINT_16 location)
{
    _lcd.pos(location);
}
////////////////////////////////////////////////////////////////////////////////

