#include "DuinOS.h"
#include "math.h"
//#include <ServoTimer2.h>
#include "CPPLib.h"

/*Port defineringar*/
int digRead =  13, debugpin = 11,ServoPin =  12, ledDataRec = 10;
int E1F = 5, E2F = 6, E1R = 14, E2R = 15;


boolean redLED_isOn = false;
boolean greenLED_isOn = false;

static boolean controlLed = false;
static boolean shift = false, wToMotors = false;
enum MessageStatus{TRUE, FALSE, ERROR};
MessageStatus newMessage = FALSE;
static boolean newSpeed = false;  
static int inByte = 0;  
static char setMotor = 'X';

//ServoTimer2 myservo;

declareTaskLoop(redLED);
declareTaskLoop(SerialComRead);
declareTaskLoop(DrivePWMA);
//declareTaskLoop(ServoDriver);

taskLoop(redLED)
{
    digitalWrite(digRead, HIGH);
    delay(100);
    digitalWrite(digRead, LOW);
    delay(100);
}


taskLoop(SerialComRead)
{
  int inChar[5] = {0,0,0,0,0};
  int index = 4, inValue = 0, i = 4; 
  char localDirection = 'X';
  newMessage = FALSE;
 
  while(Serial.available() > 0)
   { 
      inChar[index] = Serial.read();
      delay(5);
      
      if(index == 0)
        {
          newMessage = TRUE;
          break;
        }
      else
         newMessage = FALSE;  
      index--;
   }  
   
   
  if(newMessage == TRUE)
      {        
        localDirection = inChar[4];
        while(i != 0)
          {
            i--; // för att läsa rätt index i arrayen minusa först
            inValue *=10;
            inValue += inChar[i] - '0';         
          }
          
        delay(5);  
        Serial.println(localDirection);
        delay(5);
        Serial.println(inValue);
        delay(5);
        setMotor   = localDirection;
        inByte     = inValue;
        newSpeed   = true;
        newMessage = FALSE;
      }
}  


taskLoop(DrivePWMA)
{
  
  if(newSpeed)
    {
      if(setMotor == 'M')
        {
         analogWrite(E1F,inByte);
         analogWrite(E2F,inByte);  
         analogWrite(E1R,0);
         analogWrite(E2R,0);   
        }
       else if(setMotor == 'R')
       {
         analogWrite(E1F,0);
         analogWrite(E2F,0);  
         analogWrite(E1R,inByte);
         analogWrite(E2R,inByte);          
       }
      else if(setMotor == 'R')
       {
         analogWrite(E1F,0);
         analogWrite(E2F,inByte);  
         analogWrite(E1R,inByte);
         analogWrite(E2R,0);          
       }
      else if(setMotor == 'R')
       {
         analogWrite(E1F,inByte);
         analogWrite(E2F,0);  
         analogWrite(E1R,0);
         analogWrite(E2R,inByte);          
       }
       else
       {
         analogWrite(E1F,0);
         analogWrite(E2F,0);  
         analogWrite(E1R,0);
         analogWrite(E2R,0); 
       }
       setMotor = 'X';
       inByte = 0;
       newSpeed = false;    
    }
}



/*taskLoop(ServoDriver)
{
  int pos;
  
  for(pos = 1000; pos < 2000; pos += 10)  // goes from 0 degrees to 180 degrees
  {                                  // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(10);
  }
  for(pos = 2000; pos>=1000; pos-=10)     // goes from 180 degrees to 0 degrees
  {                                
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(10);
  } 

}*/


void setup()   
{ 
  Serial.begin(115200);
  
  Serial.println("0,0,0,0");
  Serial.println("Waiting for sync message...");

  pinMode(ledDataRec, OUTPUT);
  pinMode(E2R, OUTPUT);
  pinMode(debugpin, OUTPUT);
  pinMode(E1F, OUTPUT);
  pinMode(E2R, OUTPUT);
  pinMode(E2R, OUTPUT);
  //myservo.attach(ServoPin);
  
  
  createTaskLoopWithStackSize(redLED, NORMAL_PRIORITY, 50);
  createTaskLoopWithStackSize(SerialComRead, NORMAL_PRIORITY, 150);
  createTaskLoopWithStackSize(DrivePWMA, NORMAL_PRIORITY, 50);
  //createTaskLoopWithStackSize(ServoDriver, NORMAL_PRIORITY, 50);
  
}



void loop()                     
{
delay(20);
nextTask();
}