#include "mbed.h"
//#include "rtos.h"
#include "MODSERIAL.h"
#include "cnc.h"
extern  MODSERIAL pc;
//extern  Serial pc;
extern  void    move_to_XYZ   (struct pirbufgrain & ins)   ;
/*
This file contains one function:
void    lissajous   ()  ;
The purpose is to replicate a list of XY coordinates produced by a G Code programme written to run on Mach3 software
to be used to set NCOs in sequence to prove this simple code running on a 'mbed' or 'Freescale KL25Z'
does correctly drive the Sieg KX3 CNC mill, just the same as using the pc / Mach3 setup.

Thus far we have proved only that both finish at the same point (give or take a few microns)
*/
//bool    liss_active = false;    //  global flag used to prevent running more than once at a time

void    lissajous   (fl_typ feed_rate)  {
    const fl_typ    PI          = 4.0 * atan(1.0),  //3.142ish but more accurate
                    Deg2Rad     = PI / 180.0, //  degrees to radian conversion factor
                    MaxX            = 40.0,     // Plot size X to move +/- MaxX
                    MaxY            = 25.0,     // Plot size Y to move +/- MaxY
                    StartAngDegX    = 0.0,
                    StartAngDegY    = 10.0,
                    FreqRatio       = 0.255;
    const int       StepsPerRevX    = 100,
                    NumofXCycles    = 16;
    const fl_typ    AngleStepX  = (2.0 * PI / StepsPerRevX),
                    AngleStepY  = AngleStepX * FreqRatio;

//void    lissajous   (void const * arg_string)  {
    struct  pirbufgrain Coords;
    fl_typ  AngleX = StartAngDegX * Deg2Rad,
            AngleY = StartAngDegY * Deg2Rad;
            
//    pc.printf("In lissajous func, Loading Lissajous\r\n");
//    while   (1) {
//        while   (!liss_active)  //  Other code to activate
//            osThreadYield();
    //    liss_active = true;   //  this hapens in activating code
        pc.printf("In lissajous func, Starting Lissajous, has been activated\r\n");
        Coords.x = 0.0;
        Coords.y = 0.0;
        Coords.z = 12.7;
        Coords.f_rate = feed_rate;
        move_to_XYZ (Coords);
        Coords.x = MaxX * cos(AngleX);  //  Coordinates of start position
        Coords.y = MaxY * sin(AngleY);  //  assembled into packet for motion controller
        move_to_XYZ (Coords);
        Coords.z = 0.0;
        move_to_XYZ (Coords);
    
        for (int i = 0; i < NumofXCycles; i++)   {      // Outer loop 'NumofXCycles' times
            for (int j = 0; j < StepsPerRevX; j++)   {  // Inner loop 'StepsPerRevX' times
                AngleX += AngleStepX;
                AngleY += AngleStepY;
                Coords.x = MaxX * cos(AngleX);
                Coords.y = MaxY * sin(AngleY);
                move_to_XYZ (Coords);
//                osThreadYield();
            }
            pc.printf("liss cyc %d\r\n", i);
        }
        Coords.z = 100.0;
        move_to_XYZ (Coords);
        Coords.x = 0.0;
        Coords.y = 0.0;
        move_to_XYZ (Coords);
        
        pc.printf("Lissajous finish point X%f, Y%f\r\n", Coords.x, Coords.y);
//        liss_active = false;
        pc.printf("Leaving liss\r\n");
//        osThreadYield();    //  terminate would be better here
//    }   //  end of while(1)
}

/*
The complete Mach3 G Code programme listing "lissajous.txt" follows :-
*/

/*
; This Section to put machine into known, safe state
M5  ;   Stop spindle
G17 ;   Select XY plane
G21 ;   Units are mm
G40 ;   Cancel cutter radius compensation
G49 ;   Cancel tool length offset
G61 ;   Exact stop
G50 ;   Reset all scale factors to 1.0
G90 ;   Absolute distance mode
G94 ;   Feed mm per minute mode - as mm selected above by G21
;   Title:      Lissajous Pattern Generator 2014
;   Programme Name  "lissajous.txt"
;   Author:     Jon Freeman
;   Date:       Feb 2014

;   Demo code used to demonstrate Freescale FRDM-KL25Z computer board
;   driving a Sieg KX3 CNC mill without PC, and without Mach3 !!

; _____________________________________________
; Put user alterable parameter values in this section
; User is invited to alter the 6 parameters in this section.

#10 = 6.40  ;   Max 'X' excursion
#11 = 3.20  ;   Max 'Y' excursion
#12 = 0.0   ;   Start angle of 'X'
#13 = 10.0  ;   Start angle of 'Y'
#14 = 0.254 ;   Frequency ratio of X and Y signals
#15 = 100   ;   Int Steps per 2PI of X
#16 = 16    ;   Int Number of whole cycles of 'X'
;
;   Programme starts here

#50 = [#10 * cos[#12]]  ;Start X coord
#51 = [#11 * sin[#13]]  ;Start Y coord
#52 = [360.0 / #15]     ;Angle step X
#53 = [#52 * #14]       ;Angle step Y
G0 X#50 Y#51
M98 P   1000    L #16   ;Execute subroutine 'Numof X Cycles' times
M5 M30  ;   Stop, end and rewind

O 1000  ;   Subroutine executed once per complete turn of 'X'
M98 P   2000    L #15   ;Execute the subroutine and repeat 'Steps per Rev' times
M99 ;   Return

O 2000  ;   Subroutine executed 'Numof X Cycles' * 'Steps per Rev' times
#12 = [#12 + #52]   ;   Update X angle
#13 = [#13 + #53]   ;   Update X angle
#50 = [#10 * cos[#12]]  ;Update X coord
#51 = [#11 * sin[#13]]  ;Update Y coord
G1 X#50 Y#51
M99 ;   Return
*/

